/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderAdapter
 * @Package cn.freemud.adapter
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/21 20:34
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.adapter;

import cn.freemud.base.constant.Version;
import cn.freemud.entities.dto.ActivityCancelStockRequestDto;
import cn.freemud.entities.dto.CouponCodeVerificationProductDto;
import cn.freemud.enums.OrderAccountType;
import com.freemud.application.sdk.api.ordercenter.entities.v1.AccountBeanV1;
import com.freemud.application.sdk.api.ordercenter.entities.v1.OrderBeanV1;
import com.freemud.application.sdk.api.ordercenter.entities.v1.ProductBeanV1;
import com.freemud.application.sdk.api.ordercenter.entities.v1.ProductDiscountV1;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Component
public class ActivityAdapter {

    public ActivityCancelStockRequestDto convert2ActivityCancelStockRequestDto(OrderBeanV1 orderBean, List<Integer> transType) {
        ActivityCancelStockRequestDto activityCancelStockRequestDto = new ActivityCancelStockRequestDto();
        activityCancelStockRequestDto.setVer(Version.VERSION_1);
        activityCancelStockRequestDto.setPartnerCode(orderBean.getCompanyId());
        activityCancelStockRequestDto.setStoreId(orderBean.getShopId());
        activityCancelStockRequestDto.setOrderId(orderBean.getOid());
        activityCancelStockRequestDto.setTransType(transType);
        activityCancelStockRequestDto.setUserId(orderBean.getUserId());
        List<ActivityCancelStockRequestDto.ProductVo> orderProducts = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(orderBean.getProductList())) {
            orderBean.getProductList().forEach(productBean -> {
                //1.9.2兼容套餐商品改动  套餐类子集商品不校验库存
                if(StringUtils.isBlank(productBean.getParentProductId())){
                    ActivityCancelStockRequestDto.ProductVo productStock = new ActivityCancelStockRequestDto.ProductVo();
                    productStock.setSkuId(productBean.getSpecification());
                    productStock.setQty(productBean.getNumber());
                    orderProducts.add(productStock);
                }
            });
        }
        activityCancelStockRequestDto.setProducts(orderProducts);
        //优惠券冲正
        List<AccountBeanV1> accountList = orderBean.getAccountList();
        if (!CollectionUtils.isEmpty(accountList) && !CollectionUtils.isEmpty(orderBean.getProductList())) {
            for (AccountBeanV1 accountBean : accountList) {
                List<CouponCodeVerificationProductDto> products = new ArrayList<>();
                //订单中存储的6代表商品券
                if (Objects.equals(accountBean.getType(), OrderAccountType.PRODUCT_COUPON.getCode())) {
                    for (int i = 0; i < orderBean.getProductList().size(); i++) {
                        ProductBeanV1 productBean = orderBean.getProductList().get(i);
                        String pid = StringUtils.isNotBlank(productBean.getSpecification()) ? productBean.getSpecification() : productBean.getProductId();
                        if (!org.springframework.util.CollectionUtils.isEmpty(orderBean.getProductList().get(i).getDiscountList())) {
                            List<ProductDiscountV1> discounts = orderBean.getProductList().get(i).getDiscountList().stream().
                                    filter(productDiscount -> productDiscount.getDiscountId().equals(accountBean.getAccountId())).collect(Collectors.toList());
                            for (ProductDiscountV1 productDiscount : discounts) {
                                CouponCodeVerificationProductDto couponCodeVerificationProductDto = new CouponCodeVerificationProductDto();
                                couponCodeVerificationProductDto.setPID(pid);
                                couponCodeVerificationProductDto.setConsume_num(productDiscount.getDiscountQty());
                                couponCodeVerificationProductDto.setSeq(i + 1);
                                products.add(couponCodeVerificationProductDto);
                            }
                        }
                    }
                }
                if (OrderAccountType.COUPON.getCode().equals(accountBean.getType())
                        || OrderAccountType.PRODUCT_COUPON.getCode().equals(accountBean.getType())
                        || OrderAccountType.DISCOUNT_COUPON.getCode().equals(accountBean.getType())) {
                    activityCancelStockRequestDto.setCouponCode(accountBean.getAccountId());
                    activityCancelStockRequestDto.setCouponProducts(products);
                }
            }
        }
        //积分冲正
        if (!CollectionUtils.isEmpty(orderBean.getAccountList())) {
            List<AccountBeanV1> accountBean = orderBean.getAccountList().stream().filter(account -> account.getType().equals(OrderAccountType.CUSTOMER_SUB.getCode())).collect(Collectors.toList());
            if (accountBean != null && accountBean.size() > 0) {
                activityCancelStockRequestDto.setScoreReduceAmount(accountBean.get(0).getPrice() == null ? 0 : accountBean.get(0).getPrice().intValue() * -1);
            }
        }

        return activityCancelStockRequestDto;
    }

}
