package cn.freemud.utils;

import org.jasypt.encryption.StringEncryptor;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;

import javax.annotation.Resource;

@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
public class StringEncryptorTest implements Runnable{
    @Resource(name = "jasyptStringEncryptorFreemud")
    private StringEncryptor stringEncryptor;


    @Test
    public void testStringEncrypt() {
        String str = stringEncryptor.encrypt("rmqadmin@fm");
        System.out.println(str);

        str = stringEncryptor.decrypt("9/SYZECjwURR6TrpYcRhjYfR+c+ALaqk");
        System.out.println(str);

    }

    @Override
    public void run() {
        System.out.println("运行");
    }

    public static void main(String[] args) {
        Runnable runnable = new StringEncryptorTest();
        Thread thread = new Thread(runnable);
        thread.start();
        System.out.println("end");
    }
}
