package com.freemud.sdk.api.assortment.order.request.payment;

import lombok.Data;

import java.util.List;

@Data
public class CombPayRequest {

    private List<PayPlatformVO> platforms;
    /**
     * 用户标识
     */
    private String open_id;
    /**
     * 回调通知地址
     */
    private String notify_url;
    /**
     * 是否需要开发票：1为需要
     */
    private Integer invoice_flag;
    /**
     * 支付总金额，以分为单位
     */
    private Long amount;
    /**
     * 会员支付金额，以分为单位
     */
    private Long vip_amount;
    /**
     * 不可打折金额，以分为单位
     */
    private Integer undis_amount;
    /**
     * 订单描述
     */
    private String body;
    /**
     * 外部交易流水号，由上游系统生成，需保证唯一
     */
    private String out_order_no;
    private List<ProductVO> products;
    private String goodsTag;
    /**
     * 商户编号（由非码提供）
     */
    private String partner_id;
    /**
     * 商家门店号（在线支付需要提前定义）
     */
    private String store_id;
    /**
     * 业务日期
     */
    private String business_date;
    /**
     * 营业员编号（可以使用固定值）
     */
    private String operator_id = "1";
    /**
     * 商家POS机编号（可以使用固定值,扫码付必传）
     */
    private String station_id = "1";;
    private String appId;
    private String payCode;
    private String payTimeOutTime;
    private String ebCode;
    private String cardCode;
    private Boolean disable_service_goods_tag = false;
    private String request_source ="V1";
    private String ver ="10";
    private String storeName;
    private Long merchantDiscount;

    /**
     * @see  com.freemud
     * 下单所用小程序类型：1微信，2支付宝，3抖音")
     */
    private Integer applicationType;
}
