package com.freemud.application.sdk.api.ordercenter.enums;

import org.apache.commons.lang.StringUtils;

public enum OperateClient {

    POS("pos","pos"),
    ASSISTANT_SERVICE("assistant_service","小助手"),
    OPEN_PLATFORM("open_platform","开放平台"),
    TASK_CENTER("task_center","自动任务");


    /**
     * 操作类型
     */
    private String opType;
    /**
     * 操作名称
     */
    private String opName;

    OperateClient(String opType, String opName) {
        this.opType = opType;
        this.opName = opName;
    }

    public String getOpType() {
        return opType;
    }

    public void setOpType(String opType) {
        this.opType = opType;
    }

    public String getOpName() {
        return opName;
    }

    public void setOpName(String opName) {
        this.opName = opName;
    }

    public static OperateClient getByOpType(String opType){
        if (StringUtils.isEmpty(opType)) {
            return null;
        }
        for (OperateClient operateType : values()) {
            if (operateType.getOpType().equals(opType)) {
                return operateType;
            }
        }
        return null;

    }
}
