package cn.freemud.entities.dto.promotion;

import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class ActivityApportionVO {
    @ApiModelProperty(value="分摊类型：1平台优惠  2商家优惠  3其他优惠", name="code", example="2")
    @NotNull(message = "不可为空")
    private Short code;
    @ApiModelProperty(value="分摊类型名", name="name", example="商家优惠")
    @NotNull(message = "不可为空")
    private String name;
    @ApiModelProperty(value="分摊百分比（百分制）", name="ratio", example="80")
    @NotNull(message = "不可为空")
    @Min(0)
    @Max(100)
    private Short ratio;

    public Short getCode() {
        return code;
    }

    public void setCode(Short code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Short getRatio() {
        return ratio;
    }

    public void setRatio(Short ratio) {
        this.ratio = ratio;
    }
}