package cn.freemud.demoTest.controller;

import cn.freemud.demoTest.adapter.bo.ServiceBOAdapter;
import cn.freemud.demoTest.entities.bo.BasePaySuccessBo;
import cn.freemud.demoTest.service.OrderService;
import cn.freemud.entities.vo.PaysuccessNoticeMessage;
import com.freemud.application.sdk.api.log.ApiAnnotation;
import com.freemud.application.sdk.api.log.LogParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

public class OrderController {


    @Autowired
    private OrderService orderService;

    @Autowired
    private ServiceBOAdapter serviceBOAdapter;

    /**
     * 订单支付成功后通知
     */
    @ApiAnnotation(logMessage = "paySuccessCallback")
    @PostMapping("/paySuccessCallback")
    public String paySuccessCallback(@LogParams @RequestBody PaysuccessNoticeMessage message) {

        BasePaySuccessBo basePaySuccessBo = serviceBOAdapter.convert2BasePaySuccessBo(message);

        return orderService.paySuccessCallback(basePaySuccessBo);
    }

}
