package cn.freemud.entities.vo;

import cn.freemud.entities.dto.BindingCouponTypeDto;
import cn.freemud.entities.dto.product.info.ProductAttributeGroupListBean;
import lombok.Data;

import java.util.List;

@Data
public class GetProductsVo {
    private String spuId;
    private String spuName;
    private String spuPicture;
    private String skuId;
    private String skuName;
    private Long originalPrice;
    /**
     * 最终价格 单位分
     */
    private Long finalPrice;
    /**
     * 上下架状态
     */
    private Integer status;

    // 1.5.4 对接库存新加
    private Integer stock;
    private Integer stockLimit;
    /**
     * type=10 多规格  type=1 单规格
     */
    private Integer type;
    /**
     * 第三方商品编号
     */
    private String customerCode;
    /**
     * 属性
     */
    private List<ProductAttributeGroupListBean> productAttributeGroupList;
    /**
     * 分类id
     */
    private String category;
    /**
     * 分类名称
     */
    private String categoryName;
    private String defaultSpecId;
    private String defaultSpecName;
    private List<CartGoods.CartGoodsExtra> extra;

    /**
     * 虚拟商品 绑定的券信息
     */
    private List<BindingCouponTypeDto> productBindingCouponTypes;

    /**
     *  【订C，“POS编码”让凌顶那边去匹配商品】 https://www.tapd.cn/43862731/prong/stories/view/1143862731001039549
     */
    private String linkedId;

}