/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ShoppingCartUpdateRequestVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: ping.wu
 * @date: 2018/5/22 10:42
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import cn.freemud.entities.dto.calculate.Discount;
import cn.freemud.entities.dto.calculate.Goods;
import com.freemud.sdk.api.assortment.shoppingcart.domain.CartGoodsStates;
import lombok.Builder;
import lombok.Data;

import java.util.List;

@Data
public class ShoppingCartGoodsResponseVo  extends ShoppingCartGoodsBaseResponseVo{

    /**
     * 商品额外的属性
     */
    List<CartGoods> products;
    /**
     * 商品总数
     */
    private Integer productsCount;
    /**
     * 活动信息
     */
    private ActivityTip activityTip;

    /**
     * 原总价
     */
    private Long originalTotalAmount;
    /**
     * 现总价
     */
    private Long totalAmount;
    /**
     * 总折扣价
     */
    private Long totalDiscountAmount;

    /**
     * 总积分
     */
    private Long totalScore;
    /**
     * 新包装费（该字段给新版本前端展示，使其好计算）
     */
    private Long newPackAmount;

    /**
     * 包装费 收费规则　1= 商品级别 2=订单级别
     */
    private Integer packageAmountCollectType;

    /**
     * 优惠券折扣
     */
    private Long couponDiscount;

    /**
     * 满减折扣
     */
    private Long fullDiscount;
    /**
     * svc卡支付描述
     */
    private String svcDiscountDesc;

    /**
     * 可用优惠券列表
     */
    private ActivityClassifyCouponBean availableCoupon;

    private ActivityTip buyOneGetActivity;
    /**
     * 积分抵扣优惠
     */
    private ShoppingCartCustomerScoreVo customerScoreVo;
    /**
     * 起送费
     */
    private Long freeDeliveryPrice;
    /**
     * 会员卡原价
     */
    private Integer cardOriginalAmount;

    /**
     * 会员卡优惠金额
     */
    private Integer cardDiscountAmount;

    /**
     * 配送费
     */
    private Long deliveryAmount;

    /**
     * 微商城配送类型　到付  0:不包邮; 1:包邮; 2:运费到付
     */
    private Integer costType;

    /**
     * 减免后配送费
     */
    private Long discountDeliveryAmount;

    /**
     * 满多少额度 减免
     */
    private Long thresholdAmount;

    /**
     * 是否参加满额减免
     */
    @Builder.Default
    private Boolean isDiscountDelivery = false;

    /**
     * 满额减配送费描述
     */
    private String deliveryDiscountDesc;

    /**
     * 减免后配送费
     */
    private String discountDeliveryActivityCode;

    /**
     * 配送费为零的原因：0:正常,1:超出配送范围
     */
    private Integer deliveryFeeZeroReason;

    /**
     * 代金券
     */
    private String couponCode;

    /**
     * 运费券
     */
    private String freightCouponCode;
    private Integer version;

    /**
     * 麦咖啡-咖啡月卡价格
     */
    private Long payCardFee;
    /**
     * svc卡支付金额
     */
    private String svcPayAmount;

    /**
     * 积分支付数量
     */
    private String scorePayAmount;
    /**
     * 购物车版本号
     */
    private Integer carVer;

    /**
     * 总的优惠信息集合
     */
    private List<Discount> discounts;

    /**
     * 商品优惠信息
     */
    private List<Goods> goods;

    /**
     * 用户可以选择的商品
     */
    private List<chooseGood> chooseGoods;


    /**
     * 购物车商品总价
     */
    private Long shoppingCartGoodsAmount;

    /**
     * 购物车商品原总价
     */
    private Long shoppingCartOriginalGoodsAmount;

    /**
     * 加价购商品总价
     */
    private Long sendGoodsAmount;

    /**
     *  fisherman 该字段用于兼容 配送券逻辑使用
     *  场景: 新算价  活动和配送券共享情况下 前端结算页 小结计算展示有问题
     *  目的: 兼容 订单结算页 小结展示问题
     */
    private Integer verCompat = 0;

    /**
     * 参与积分商品活动积分不足
     */
    private Boolean isInsufficientScore = false;

    /**
     * 选中的可用优惠券集合
     */
    private List<ChooseCouponVo> couponCodes;


    /**
     * 购物车是否有非法商品或价格变动
     */
    private CartGoodsStates cartGoodsStates;

    /**
     * fisherman 一单多券, 剔除购物车内券商品的使用门槛
     *
     */
    private Long useCouponThreshold ;

    @Data
    public static class chooseGood {

        /**
         * 购物车一行的Id（后台生成）
         */
        private String cartGoodsUid;

        /**
         * 活动code
         */
        private String activeCode;

        /**
         * 活动类型
         */
        private Integer activeType;

        /**
         * 赠送商品名称
         */
        private String goodsName;

        /**
         * 赠送商品id
         */
        private String goodsId;

        /**
         * 赠送商品数量
         */
        private Integer qty;

        /**
         * 可兑换商品券编号
         */
        private String couponCode ;

        /**
         * 可兑换券的数量
         */
        private Integer couponQty ;

        /**
         *  可兑换商品券名称
         */
        private String couponName ;

        /**
         *  是否已选择寄杯
         */
        private Boolean sendCoupon;

    }
}
