package com.freemud.application.sdk.api.ordercenter.enums.orderv1;

public enum RefundStatusV1 {

    APPLY_REFUND(1, "申请退款"),
    AGREE_REFUND(2, "同意退款"),
    ALREADY_REFUND(3, "已退货"),
    COMPLETE_REFUND(4, "退款完成"),
    REFUSE_REFUND(5, "拒绝退款");


    private Integer code;
    private String desc;

    RefundStatusV1(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static RefundStatusV1 getByCode(Integer code) {
        for (RefundStatusV1 status : values()) {
            if (status.getCode().equals(code)) {
                return status;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

}
