package cn.freemud.service.thirdparty;

import cn.freemud.annotations.LogIgnoreFeign;
import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.QueryInvoiceRepDto;
import cn.freemud.entities.dto.order.QueryInvoiceByCodesResponse;
import cn.freemud.entities.dto.pay.OrderInvoiceRequest;
import cn.freemud.entities.dto.pay.QueryInvoiceByCodesRequest;
import cn.freemud.entities.vo.QueryInvoiceReq;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(name = "order-service",url = "${order.service.url:}")
@RequestMapping(consumes = MediaType.APPLICATION_JSON_UTF8_VALUE, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public interface OrderServiceClient {
    /**
     * 创建订单开票记录
     */
    @LogIgnoreFeign(logMessage="createInvoice")
    @PostMapping("/order/v2/invoice/create")
    BaseResponse createInvoice(@RequestBody OrderInvoiceRequest orderCounts);

    /**
     * 查询用户订单号是否已开票
     */
    @LogIgnoreFeign(logMessage="queryInvoiceByCodes")
    @PostMapping("/order/v2/invoice/queryByCodes")
    BaseResponse<QueryInvoiceByCodesResponse> queryInvoiceByCodes(@RequestBody QueryInvoiceByCodesRequest request);

    /**
     * 2021年9月15日-开票历史列表接口+详情接口+发票所含订单接口-黄兆良
     * 开票历史列表接口
     */
    @LogIgnoreFeign(logMessage="queryInvoiceList")
    @PostMapping(value = "/order/v2/invoice/list/forUser")
    QueryInvoiceRepDto queryInvoiceList(@RequestBody QueryInvoiceReq queryInvoiceReq);

}
