package cn.freemud.service;

import cn.freemud.entities.dto.ConfirmOrderDto;
import cn.freemud.entities.dto.order.CreateCashierOrderDto;
import cn.freemud.entities.vo.CreateOrderResponseVo;
import cn.freemud.entities.vo.PaysuccessNoticeMessage;
import com.freemud.api.assortment.datamanager.entity.vo.AssortmentCustomerInfoVo;
import com.freemud.application.sdk.api.ordercenter.entities.v1.OrderBeanV1;

import java.util.Map;

/**
 * @author Clover.z
 * @Date 2021/10/20
 * @Desc 收银订单 service
 */
public interface CashierOrderService {


    /**
     * 创建无单收银订单
     * 不需要查询购物车，没有商品，流程上 只需要创建一个订单然后唤起预支付就行了
     * @param createOrderDto 请求数据
     * @param member 会员信息
     * @return 预支付信息
     */
    CreateOrderResponseVo createOrder(CreateCashierOrderDto createOrderDto, AssortmentCustomerInfoVo member);


    /**
     * 支付成功回调处理
     * @param message 支付消息
     * @param confirmOrderDto 支付成功消息dto
     * @param orderBeans 订单信息
     * @return 处理结果json字符串
     */
    String paySuccessCallback(PaysuccessNoticeMessage message, ConfirmOrderDto confirmOrderDto, Map<String, OrderBeanV1> orderBeans);
}
