package cn.freemud.management.intercept;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.management.util.ResponseUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: BizExceptionHandler 拦截校验参数
 * @Package com.freemud.base.exception
 * @Description: 全局异常处理
 * @author: aiqi.gong
 * @date: 2017/5/8 11:27
 * @Copyright: 2017 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@RestControllerAdvice
public class OrderExceptionHandler {


    @ExceptionHandler(OrderServiceException.class)
    @ResponseStatus(HttpStatus.OK)
    public BaseResponse bindException(OrderServiceException e) {
        return ResponseUtil.error(e.getResult());
    }

    @ExceptionHandler(PaymentServiceException.class)
    @ResponseStatus(HttpStatus.OK)
    public BaseResponse bindException(PaymentServiceException e) {
        return ResponseUtil.error(e.getResult().getCode(),e.getMessage());
    }

    @ExceptionHandler(DeliveryServiceException.class)
    @ResponseStatus(HttpStatus.OK)
    public BaseResponse bindException(DeliveryServiceException e) {
        return ResponseUtil.error(e.getResult().getCode(),e.getMessage());
    }
}