package cn.freemud.controller.test;

import cn.freemud.service.thirdparty.EcologyAdminApplicationClient;
import cn.freemud.service.thirdparty.WeChatClient;
import com.alibaba.fastjson.JSONObject;
import com.freemud.application.sdk.api.log.ApiAnnotation;
import com.freemud.application.sdk.api.log.LogParams;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * All rights Reserved, Designed By www.freemud.com
 *
 * @version V1.0
 * @Title:
 * @Package: cn.freemud.controller
 * @Descripttion:
 * @author: shuhu.hou
 * @date: 2019/7/8
 * @Copyright: 2017 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目.
 */
@Slf4j
@RestController
@Validated
public class TestController {

    @Autowired
    private EcologyAdminApplicationClient ecologyAdminApplicationClient;
    @Autowired
    private WeChatClient weChatClient;

    @ApiAnnotation(logMessage = "orderStatusChange")
    @PostMapping("/orderStatusChange")
    public PlatformBaseResponse orderStatusChange(@Validated @LogParams @RequestBody PlatformBaseRequest checkBeforeCreateOrderRequestVo) {
        PlatformBaseResponse platformBaseResponse = new PlatformBaseResponse();
        platformBaseResponse.setStatusCode("100");
        return platformBaseResponse;
    }

    @ApiAnnotation(logMessage = "refundStatusChange")
    @PostMapping("/refundStatusChange")
    public PlatformBaseResponse refundStatusChange(@Validated @LogParams @RequestBody PlatformBaseRequest checkBeforeCreateOrderRequestVo) {
        PlatformBaseResponse platformBaseResponse = new PlatformBaseResponse();
        platformBaseResponse.setStatusCode("100");
        return platformBaseResponse;
    }

    @ApiAnnotation(logMessage = "testOrderDelivery")
    @PostMapping("/testOrderDelivery")
    public PlatformBaseResponse testOrderDelivery(@Validated @LogParams @RequestBody PlatformBaseRequest platformBaseRequest) {
        PlatformBaseResponse platformBaseResponse = new PlatformBaseResponse();
        platformBaseResponse.setStatusCode("100");
        log.info("testOrderDelivery get {}",JSONObject.toJSONString(platformBaseRequest));
        return platformBaseResponse;
    }
}
