/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: MessageNoticeAdapter
 * @Package cn.freemud.adapter
 * @Description:
 * @author: liming.guo
 * @date: 2018/6/1 10:50
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.adapter;

import cn.freemud.entities.dto.PushMessageNoticeDto;
import cn.freemud.entities.dto.PushMessageTokenDto;
import com.google.gson.Gson;
import org.springframework.stereotype.Component;

@Component
public class MessageNoticeAdapter {

    public PushMessageTokenDto convent2PushMessageTokenDto(String partnerId, String storeId, String userId, String token) {
        PushMessageTokenDto pushMessageTokenDto = new PushMessageTokenDto();
        pushMessageTokenDto.setPartnerId(partnerId);
        pushMessageTokenDto.setStoreId(storeId);
        pushMessageTokenDto.setTargetId(userId);
        pushMessageTokenDto.setTargetType(1);
        pushMessageTokenDto.setToken(token);
        return pushMessageTokenDto;
    }

    public PushMessageNoticeDto convent2PushMessageNoticeDto(Integer targetType, String partnerId,
                                                             String storeId, String userId, String oid, String takeCode, String queueIndex) {
        PushMessageNoticeDto pushMessageNoticeDto = new PushMessageNoticeDto();
        pushMessageNoticeDto.setPartnerId(partnerId);
        pushMessageNoticeDto.setStoreId(storeId);
        pushMessageNoticeDto.setTargetId(userId);
        pushMessageNoticeDto.setTargetType(targetType);
        pushMessageNoticeDto.setCmd(1);
        PushMessageNoticeDto.Message message = new PushMessageNoticeDto.Message();
        message.setType(1);
        if (targetType == 1) {
            PushMessageNoticeDto.Message.Content content = new PushMessageNoticeDto.Message.Content();
            content.setOid(oid);
            content.setTake_code(takeCode);
            content.setQueueIndex(queueIndex);
            message.setContent(content);
        }
        pushMessageNoticeDto.setData(new Gson().toJson(message));
        return pushMessageNoticeDto;
    }
}
