package cn.freemud.entities.dto.delivery;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 查询省份对应配送费价格响应对象
 * @version V1.0
 * @author: kai.ding
 * @date:  
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * All rights Reserved, Designed By www.freemud.cn
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class CancelDeliveryResponseDto {

    private Integer code;

    private String msg;

    private Object data;

    @Data
    public static class QueryDeliveryAmountResult {

        private Long id;

        /**
         *  商户ID
         */
        private String partnerId;

        /**
         * 配送费 单位：分
         */
        private BigDecimal deliveryAmount;

        /**
         * 收件人省份编码
         */
        private String provinceCode;

        /**
         * 收件人省份
         */
        private String sendProvince;

        /**
         * 状态 1启用 2禁用
         */
        private Integer status;
    }
}
