/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ShoppingCartUpdateRequestVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: ping.wu
 * @date: 2018/5/22 10:42
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import java.util.List;

@Data
@ApiModel
public class AddShoppingCartGoodsRequestVo extends BaseRequestVo{

    @NotEmpty(message = "sessionId不能为空")
    private String sessionId;

    /**
     * 拼单发起人userId（拼单）
     */
    private String createCollageUserId;

    /**
     * 购物车版本号（拼单）
     */
    private Integer carVer;

    /**
     * 微信appId
     */
    @NotEmpty(message = "appId不能为空")
    private String appId;

    @NotEmpty(message = "spuId不能为空")
    private String spuId;

    private String skuId;
    /**
     * 商品额外的属性
     */
    private List<CartGoods.CartGoodsExtra> extra;

    private String version;

    /**
     * 1.6.0 版本增加  节点ID
     */
    private String nodeId;
    /**
     * 1.6.0 版本增加 分类名
     */
    private String categoryName;
    /**
     * 套餐固定商品
     */
    private List<ComboxGoodsRequestVo> productComboList;
    /**
     * 套餐可选商品
     */
    private List<ComboxGoodsRequestVo> productGroupList;

    /**
     * 加料
     */
    private List<MaterialRequestVo> productMaterialList;
    private String appType;

    private String tableNumber;
    /**
     * 数量
     */
    private Integer qty;

    /**
     * 业务类型： 0 : 自提 1：外卖 2：微商城
     */
    private String menuType ;

    /**
     * 收货地址ID、svc卡支付外卖订单必传
     */
    private String receiveId;

    /**
     * 操作类型 1= 添加商品券 2=加价购
     */
    private Integer operationType;

    /**
     * 优惠券号
     */
    private String couponCode;

    /**
     * 购买类型 1=普通购买 1=立即购买 ，默认值为普通购买
     */
    @ApiModelProperty(value = "购买类型 1=普通购买 1=立即购买 ，默认值为普通购买")
    private int buyType = 0;

}
