package cn.freemud.entities.dto.coupon;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2021/11/9 下午2:43
 * @description :
 */
@Data
public class FastTemplateInfoResponseVO {
    @ApiModelProperty(value = "模板编号", required = true)
    private String templateCode;

    @ApiModelProperty(value = "模板名称", required = true)
    private String templateName;

    @ApiModelProperty(value = "券类型：0 商品券 1 代金券 3 折扣券 4 换购券 5 配送券 6商品兑换券 7买M免N券", required = true)
    private Integer type;

    @ApiModelProperty("券子类型，目前只对商品券生效，0：白名单商品券，1：黑名单商品券")
    private Integer subType;

    @ApiModelProperty(value = "固定有效期开始时间，格式YYYY-MM-DD HH:mm:ss", required = true)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date effectiveStartTime;

    @ApiModelProperty(value = "固定有效结束时间，格式YYYY-MM-DD HH:mm:ss", required = true)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date effectiveEndTime;

    @ApiModelProperty(value = "领券结束时间，格式YYYY-MM-DD HH:mm:ss", required = true)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date receiveEndTime;

    @ApiModelProperty(value = "领券开始时间，格式YYYY-MM-DD HH:mm:ss", required = true)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date receiveStartTime;

    @ApiModelProperty(value = "启用金额，单位：分", required = true)
    private Integer minAmount;

    @ApiModelProperty(value = "券面值，折扣券时，10代表1折，65代表6.5折。其他券时单位为分，如100=1元", required = true)
    private Integer faceValue;

    @ApiModelProperty("固定时长有效期类型的券，领取后等待生效天数，0代表立即生效。")
    private Integer fromDayEffective;

    @ApiModelProperty("固定时长有效期类型的券，生效后几天内有效")
    private Integer effectiveDays;

    @ApiModelProperty("券图片")
    private String logo;

    @ApiModelProperty("券扩展类型")
    private Integer extentType;

    @ApiModelProperty("门店限制类型，当“门店或渠道限制类型”为“门店限制”时生效，当 1：所有门店，2：部分门店，3：发券指定门店")
    private Integer storeLimitType;

    @ApiModelProperty("门店或渠道限制类型，1：门店限制，2：渠道限制")
    private Integer storeChannelLimitType;

    @ApiModelProperty("活动状态：0未启用、 1启用、2开始、 3结束、 4暂停、5作废、6禁用")
    private Integer status;
}
