package cn.freemud.controller;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.vo.*;
import cn.freemud.enums.ResponseResult;
import cn.freemud.service.impl.mcoffee.ShoppingCartMCoffeeServiceImpl;
import cn.freemud.utils.ResponseUtil;
import com.freemud.application.sdk.api.log.ApiAnnotation;
import com.freemud.application.sdk.api.log.LogParams;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: MCoffeeShoppingCartController
 * @Package cn.freemud.controller
 * @Description:
 * @author: ping1.wu
 * @date: 2020/7/21 17:37
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@RestController
@RequestMapping(value = "/shoppingCart/MCoffee", consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(value = "购物车 controller", tags = {"购物车管理接口"})
@Slf4j
public class MCoffeeShoppingCartController {

    @Autowired
    private ShoppingCartMCoffeeServiceImpl shoppingCartMCoffeeService;

    /**
     * 向购物车中添加商品
     */
    @ApiAnnotation(logMessage = "addGoods")
    @PostMapping(value = "/addGoods")
    public BaseResponse addGoods(@Validated @LogParams @RequestBody AddShoppingCartGoodsRequestVo request) {
        return shoppingCartMCoffeeService.addGoods(request);
    }

    /**
     * 修改购物车中商品数量
     */
    @ApiAnnotation(logMessage = "updateGoodsQty")
    @PostMapping(value = "/updateGoodsQty")
    public BaseResponse updateGoodsQty(@Validated @LogParams @RequestBody UpdateShoppingCartGoodsQtyRequestVo request) {
        return shoppingCartMCoffeeService.updateGoodsQty(request);
    }

    /**
     * 查询购物车信息
     */
    @ApiAnnotation(logMessage = "listCartGoods")
    @PostMapping(value = "/listCartGoods")
    public BaseResponse listCartGoods(@Validated @LogParams @RequestBody ShoppingCartInfoRequestVo request) {
        return shoppingCartMCoffeeService.getGoodsList(request);
    }

    /**
     * 查询购物车可使用优惠券
     */
    @ApiAnnotation(logMessage = "availableCoupon")
    @PostMapping(value = "/availableCoupon")
    public BaseResponse availableCoupon(@Validated @LogParams @RequestBody ShoppingCartInfoRequestVo request) {
        return shoppingCartMCoffeeService.availableCoupon(request);
    }

    /**
     * 清空购物车
     */
    @ApiAnnotation(logMessage = "clearCartGoods")
    @PostMapping(value = "/clearCartGoods")
    public BaseResponse clearCartGoods(@Validated @LogParams @RequestBody ShoppingCartClearRequestVo request) {
        return shoppingCartMCoffeeService.clear(request);
    }

    /**
     * 获取购物车均摊详情，点 "去支付" 时调用
     */
    @ApiAnnotation(logMessage = "getShoppingCartGoodsApportion")
    @PostMapping(value = "/getShoppingCartGoodsApportion")
    public BaseResponse getShoppingCartGoodsApportion(@Validated @LogParams @RequestBody GetShoppingCartGoodsApportionRequestVo requestVo) {
        return shoppingCartMCoffeeService.getShoppingCartGoods(requestVo);
    }


}
