/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: GetMemberCouponListRequestDto
 * @Package cn.freemud.entities.dto
 * @Description:
 * @author: song.cai
 * @date: 2018/12/24 16:49
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.entities.vo;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.List;

@Data
@NoArgsConstructor
public class GetMemberCouponListResponseVo {


    /**
     * 总页数
     */
    private Integer pageCount;
    /**
     * 总数
     */
    private Integer totalRecord;
    /**
     * 优惠券列表
     */
    private List<MemberCoupon> coupons;

    @Data
    public final static class MemberCoupon {
        /**
         * 优惠券ID
         */
        private String couponId;
        /**
         * 优惠券号
         */
        private String couponCode;
        /**
         * 活动号
         */
        private String activityCode;
        /**
         * 是否展示加入卡包按钮（0：不展示，1：添加到卡包，2:已添加）
         */
        private String addCardFlag;
        /**
         * 优惠券名称
         */
        private String activityName;
        /**
         * 生效开始时间(yyyy-MM-dd)
         */
        private String startTime;
        /**
         * 生效结束时间(yyyy-MM-dd)
         */
        private String endTime;
        /**
         * 日期描述
         */
        private String dateDescribe;
        /**
         * 折扣百分比（折扣券时有）
         */
        private BigDecimal percentDiscount;
        /**
         * 优惠券金额（代金券）
         */
        private Long priceOriginal;
        /**
         * 最低金额（满多少可用）
         */
        private Long minAmount;
        /**
         * 优惠券使用说明
         */
        private String remark;
        /**
         * 满多少可用描述
         */
        private String thresholdDesc;
        /**
         * 券类型:
         * 0:商品券;1:代金券;2:折扣券
         */
        private Integer type;
        /**
         * 发码时间
         */
        private String createTime;
        /**
         * 核销时间
         */
        private String redeemTime;
        /**
         * 状态
         */
        private Integer status;
        /**
         * 券详情
         */
        private MemberCouponDetail detail;
    }
    @Data
    public final static class MemberCouponDetail{
        /**
         * 生效开始时间(yyyy-MM-dd)
         */
        private String startTime;
        /**
         * 生效结束时间(yyyy-MM-dd)
         */
        private String endTime;
        /**
         * 优惠券名称
         */
        private String activityName;
        /**
         * 优惠券使用说明
         */
        private String remark;
        /**
         * 金额描述
         */
        private String amountDesc;
        /**
         * 券条形码
         */
        private String couponBarCode;
    }

}
