package cn.freemud.client;

import cn.freemud.entities.dto.*;
import cn.freemud.service.thirdparty.CustomerClient;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: MemberClientTest
 * @Package cn.freemud.client
 * @Description: 简单描述下这个类是做什么用的
 * @author: zhenghuan.yang
 * @date: 2018/6/22 19:48
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Slf4j
@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
public class MemberProductClientTest {

    @Autowired
    private CustomerClient customerClient;

    /**
     * 获取用户信息
     */
    @Test
    public void getUserInfo() {
        GetMemberInfoByChannelRequestDto getMemberInfoByChannelRequestDto = new GetMemberInfoByChannelRequestDto();
        getMemberInfoByChannelRequestDto.setChannelCode("dcxcx");
        getMemberInfoByChannelRequestDto.setPartnerId("1864");

        getMemberInfoByChannelRequestDto.setThirdPartyCode("wxa23255532111212");

        GetMemberInfoByChannelResponseDto getMemberInfoByChannelResponseDto = customerClient.getMemberInfoByChannel(new GetMemberInfoByChannelRequestDto());
        System.out.println("getMemberInfoResponseDto===" + getMemberInfoByChannelResponseDto);
    }

    /**
     * 根据聚道注册会员
     */
    @Test
    public void registerbychannel() {
        MemberRegisterRequestDto memberRegisterRequestDto = new MemberRegisterRequestDto();
        memberRegisterRequestDto.setChannelCode("xcx");
        memberRegisterRequestDto.setMobile("13645689654");
        memberRegisterRequestDto.setPartnerId("360bb48b-5316-458a-903e-9a44c7f339b1");
        memberRegisterRequestDto.setRegisterType("2");
        memberRegisterRequestDto.setThirdPartyCode("ob0iP4gZeV0jWtRWxRmGtBuE0M9k");
        MemberRegisterResponseDto memberRegisterResponseDto = customerClient.registerByChannel(new MemberRegisterRequestDto());
        log.info("userRegisterResponse===" + memberRegisterResponseDto);
    }

    /**
     * 修改会员信息
     */
    @Test
    public void editUserInfo() {
        EditMemberInfoRequestDto editMemberInfoRequestDto = EditMemberInfoRequestDto.builder()
                .memberId("72057594039927937")
                .mobile("13645689654")
                .nickName("test")
                .partnerId("360bb48b-5316-458a-903e-9a44c7f339b1")
                .build();
        JSONObject str = customerClient.editMemberInfo(editMemberInfoRequestDto);
        log.info("str===" + str);
    }

    /**
     * 获取用户收货地址列表
     */
    @Test
    public void getReceiveList() {
        GetReceiveAddressListDto getReceiveListDto = new GetReceiveAddressListDto();
        getReceiveListDto.setMemberId("115282020944628617");
        getReceiveListDto.setLatitude("31.26711");
        getReceiveListDto.setLongitude("121.3773");
        getReceiveListDto.setPageNum(1);
        getReceiveListDto.setPageSize(10);
        getReceiveListDto.setPartnerId("360bb48b-5316-458a-903e-9a44c7f339b1");
        System.out.println("getReceiveListDto==" + new Gson().toJson(getReceiveListDto));
        GetReceiveAddressListResponseDto receiveList = customerClient.getReceiveAddressList(getReceiveListDto);
        log.info("receiveList===" + JSON.toJSON(receiveList));
    }

    /**
     * 新增收货地址
     */
    @Test
    public void addReceive() {
        AddReceiveAddressDto addReceiveDto = new AddReceiveAddressDto();
        addReceiveDto.setMemberId("115282020944628617");
        addReceiveDto.setIsDefault(2);
        addReceiveDto.setLabelType(1);
        addReceiveDto.setLatitude("31.26711");
        addReceiveDto.setLongitude("121.3773");
        addReceiveDto.setPartnerId("360bb48b-5316-458a-903e-9a44c7f339b1");
        addReceiveDto.setReceiveAddress("耀光国际");
        addReceiveDto.setMobile("18326910756");
        addReceiveDto.setReceiveName("张三测试");
        addReceiveDto.setSex(1);
        addReceiveDto.setZipCode("123456");
        System.out.println("addReceiveDto==" + new Gson().toJson(addReceiveDto));
        AddReceiveAddressResponseDto addReceiveDtoResponseDto = customerClient.addReceiveAddress(addReceiveDto);
        log.info("addReceiveDtoResponseDto===" + JSON.toJSON(addReceiveDtoResponseDto));
    }

    /**
     * 修改收货地址
     */
    @Test
    public void updateReceiveAddress() {
        UpdateReceiveAddressDto updateReceiveAddressDto = new UpdateReceiveAddressDto();

        updateReceiveAddressDto.setReceiveId("3215308770802017692");
        updateReceiveAddressDto.setMemberId("115308610633036895");
        updateReceiveAddressDto.setIsDefault(true);
        updateReceiveAddressDto.setLabelType(1);
        updateReceiveAddressDto.setLatitude("31.26711");
        updateReceiveAddressDto.setLongitude("121.3773");
        updateReceiveAddressDto.setPartnerId("360bb48b-5316-458a-903e-9a44c7f339b1");
        updateReceiveAddressDto.setSex(1);
        updateReceiveAddressDto.setReceiveName("小苹果333");
        updateReceiveAddressDto.setMobile("15170070311");
        updateReceiveAddressDto.setReceiveAddress("耀光中环国际 S座");
        UpdateReceiveAddressResponseDto updateReceiveAddressResponseDto = customerClient.updateReceiveAddress(updateReceiveAddressDto);
        log.info("updateReceiveAddressResponseDto===" + new Gson().toJson(updateReceiveAddressResponseDto));
    }

    @Test
    public void deleteReceiveAddress() {
        DeleteReceiveAddressDto deleteReceiveAddressDto = new DeleteReceiveAddressDto();
        deleteReceiveAddressDto.setPartnerId("360bb48b-5316-458a-903e-9a44c7f339b1");
        deleteReceiveAddressDto.setAddressId("3215308435962838338");
        DeleteReceiveAddressResponseDto responseDto = customerClient.deleteReceiveAddress(deleteReceiveAddressDto);
        log.info("responseDto===" + JSON.toJSON(responseDto));
    }


    @Test
    public void queryReceiveAddressById() {
        QueryReceiveAddressDto dto = new QueryReceiveAddressDto();
        dto.setPartnerId("360bb48b-5316-458a-903e-9a44c7f339b1");
        dto.setAddressId("3215304960378195128");
        System.out.println("str==" + new Gson().toJson(customerClient.queryReceiveAddressById(dto)));
    }
}
