package cn.freemud.management.service.handle;

import cn.freemud.management.adapter.McCafeCouponAdapter;
import cn.freemud.management.entities.dto.request.order.MCCafeCouponLockRequest;
import cn.freemud.management.entities.dto.request.order.MCCafeCouponRequest;
import cn.freemud.management.thirdparty.CouponOfflineMCCafeClient;
import com.alibaba.fastjson.JSONObject;
import com.freemud.application.sdk.api.couponcenter.offline.response.CouponBaseResponse;
import com.freemud.application.sdk.api.couponcenter.offline.response.CouponRedeemResponse;
import com.freemud.application.sdk.api.log.ApiLog;
import com.freemud.application.sdk.api.ordercenter.util.LogUtil;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrdersResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class CouponHandle {

    public final static Integer RESPONSE_SUCCESS = 100;
    @Autowired
    private McCafeCouponAdapter mcCafeCouponAdapter;
    @Autowired
    private CouponOfflineMCCafeClient couponOfflineMCCafeClient;
    @Autowired
    private LogUtil logUtil;
    /**
     * 异步核销券码
     * @param orderBean
     */
    @Async("couponExecutor")
    public void asyncVerificationCoupon(QueryOrdersResponse.DataBean.OrderBean orderBean){
        List<MCCafeCouponRequest> list = mcCafeCouponAdapter.convertOrderBean2CouponLockRequest(orderBean);
        if (CollectionUtils.isNotEmpty(list)) {
            for (MCCafeCouponRequest mcCafeCouponRequest: list) {
                //重试3次
                for (int i = 2; i >= 0; i--) {
                    logUtil.info("核销券码入参：{}",JSONObject.toJSONString(mcCafeCouponRequest));
                    CouponRedeemResponse redeem = couponOfflineMCCafeClient.redeem(mcCafeCouponRequest);
                    if (RESPONSE_SUCCESS.equals(redeem.getStatusCode())) {
                        break;
                    }
                    if (i == 0 && !RESPONSE_SUCCESS.equals(redeem.getStatusCode())) {
                        //特殊处理
                        ApiLog.printLog("麦咖啡核销券码异常",JSONObject.toJSONString(mcCafeCouponRequest),JSONObject.toJSONString(redeem),null);
//                        logUtil.info("","核销券码异常 mcCafeCouponRequest:{}, redeem:{}",null, mcCafeCouponRequest, redeem);
                    }
                }
            }
        }
    }

    /**
     * 解锁券码
     * @param orderBean
     */
    public void unlock(QueryOrdersResponse.DataBean.OrderBean orderBean){
        List<MCCafeCouponLockRequest> list = mcCafeCouponAdapter.convertOrderBean2UnlockCoupon(orderBean);
        if (CollectionUtils.isNotEmpty(list)) {
            for (MCCafeCouponLockRequest mcCafeCouponLockRequest: list) {
                //重试3次
                for (int i = 2; i >= 0; i--) {
                    CouponBaseResponse response = couponOfflineMCCafeClient.unlock(mcCafeCouponLockRequest);
                    if (RESPONSE_SUCCESS.equals(response.getStatusCode())) {
                        break;
                    }
                    if (i == 0 && !RESPONSE_SUCCESS.equals(response.getStatusCode())) {
                        logUtil.error("","解锁券码异常 mcCafeCouponLockRequest:{}, response:{}",null, mcCafeCouponLockRequest, response);
                    }
                }
            }
        }
    }

}
