package cn.freemud.service.thirdparty;

import cn.freemud.annotations.LogIgnoreFeign;
import cn.freemud.entities.dto.user.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

@FeignClient(name = "customer-property-service", url = "${customer.property.service.url:}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface CustomerPropertyClient {


    @LogIgnoreFeign(logMessage="useScore")
    @PostMapping(value = "/propertyservice/score/pay")
    CustomerPropertyBaseResponse<PayScoreResponse> useScore(@RequestBody UseScoreRequest userScoreRequest);


    @LogIgnoreFeign(logMessage="statisticalScore")
    @PostMapping({"/propertyservice/score/statisticalScore"})
    CustomerPropertyBaseResponse<StatislScoreResponse> statisticalScore(StatisticalScoreRequestVo request);

    //查询用户储值卡或会员卡
    @LogIgnoreFeign(logMessage="getMemberCards")
    @PostMapping({"/propertyservice/card/getMemberCards"})
    CustomerPropertyBaseResponse<List<GetSvcInfoByMemberIdResponseVo>> getMemberCards(StatisticalScoreRequestVo request);

}
