package cn.freemud.manager;

import cn.freemud.entities.db.OpenPlatformPartnerConfig;
import cn.freemud.manager.dao.OpenPlatformPartnerConfigDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 商户配置manager
 * @author zhenghuan.yang
 * @date 2019/03/29
 */
@Component
public class OpenPlatformPartnerConfigManager {

    @Autowired
    private OpenPlatformPartnerConfigDao openPlatformPartnerConfigDao;

    public OpenPlatformPartnerConfig selectPartnerConfigByPartnerKey(String partnerId,String partnerKey,Integer state) {
        OpenPlatformPartnerConfig config = new OpenPlatformPartnerConfig();
        config.setPartnerId(partnerId);
        config.setPartnerKey(partnerKey);
        config.setState(state);
        return openPlatformPartnerConfigDao.selectOne(config);
    }
    public int insert(OpenPlatformPartnerConfig config) {
        return openPlatformPartnerConfigDao.insert(config);
    }

}
