package cn.freemud.service;

import cn.freemud.ShoppingCartApplication;
import cn.freemud.entities.dto.CheckSpqInfoRequestDto;
import cn.freemud.entities.dto.CheckSpqInfoResponseDto;
import cn.freemud.entities.dto.GetCouponDetailResponseDto;
import cn.freemud.entities.dto.calculate.CalculationSharingDiscountResponseDto;
import cn.freemud.entities.vo.CartGoods;
import cn.freemud.entities.vo.GetMemberCouponRequestVo;
import cn.freemud.entities.vo.ShoppingCartGoodsResponseVo;
import cn.freemud.service.impl.calculate.CalculationCommonService;
import cn.freemud.service.impl.calculate.promotion.FullSharingService;
import cn.freemud.utils.FileUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.freemud.card.sdk.comm.Finals;
import com.freemud.card.sdk.comm.SignUtil;
import com.freemud.card.sdk.service.*;
import com.freemud.card.sdk.util.DateUtil;
import com.freemud.card.sdk.vo.comm.GetCodeRespVo;
import com.freemud.card.sdk.vo.comm.GetCouponVo;
import com.freemud.card.sdk.vo.coupon.CouponVo;
import com.freemud.card.sdk.vo.coupon.MemberCouponVo;
import com.freemud.card.sdk.vo.coupon.request.ActiveInsertRequest;
import com.freemud.card.sdk.vo.coupon.request.MemberCardVo;
import com.freemud.card.sdk.vo.coupon.request.PromotionUserCouponReqVo;
import com.freemud.card.sdk.vo.coupon.response.ActiveInsertRespVo;
import com.freemud.card.sdk.vo.coupon.response.MemberCouponRespVo;
import com.freemud.card.sdk.vo.coupon.response.PromotionBaseRespVo;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title:
 * @Package: com.freemud.card.sdk
 * @Description:
 * @author: genyou.cui
 * @date: 2018/12/17 16:34
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@RunWith(SpringRunner.class)
@SpringBootTest(classes = ShoppingCartApplication.class)
public class CouponTest {

    private static final Logger logger = LoggerFactory.getLogger(CouponTest.class);
    @Autowired
    private FMCouponService fmCouponService;
    @Autowired
    private FMActiveService fmActiveService;
    @Autowired
    private GetCouponService getCouponService;
    @Autowired
    private MemberProductService memberProductService;
    @Autowired
    private PromotionService promotionService;
    @Autowired
    private RedeemCouponService redeemCouponService;
    @Autowired
    private CouponService couponService;
    @Autowired
    private CalculationCommonService calculationCommonService;
    @Autowired
    private FullSharingService fullSharingService;

    @Test
    public void testGetCoupon() {
        String fileName = "getCoupons";
        GetCouponVo getCouponVo = FileUtil.getObjectFromFile(fileName, GetCouponVo.class);
        GetCodeRespVo codeRespVo = getCouponService.getCoupons(getCouponVo);
        logger.info(JSONObject.toJSONString(codeRespVo));

    }

    @Test
    public void couponCreate() {
        String partnerId = "1864";
        MultiValueMap<String, String> couponOnlineMap = new LinkedMultiValueMap<>();
        couponOnlineMap.add(Finals.PARTNER_ID, partnerId);
        couponOnlineMap.add(Finals.MERCHANT_ID, partnerId);
        couponOnlineMap.add(Finals.ORDER_ID, "ISAASTest123456789");
        couponOnlineMap.add(Finals.ACTIVECODE, "C201811151617006zhvy");
        couponOnlineMap.add(Finals.VALID_ENDS, "2019-12-01 00:00:00");
        couponOnlineMap.add(Finals.VALID_START, "2018-12-01 00:00:00");
        String mobile = "15651101234";
        couponOnlineMap.add(Finals.MOBILE, mobile);

        couponOnlineMap.add(Finals.TITLE, "cyj可领5次券");
        couponOnlineMap.add(Finals.TIMESTAMP, DateUtil.getCurrentDate(DateUtil.FORMAT_YYYY_MM_DD_HHMMSS));
        couponOnlineMap.add(Finals.NUMBER, "1");
        couponOnlineMap.add(Finals.ACTION, "code.create");

        String appSecret = "C0CB6FCDE7C745F4AEE81A152F77B728";
        Map<String, String> signMap = couponOnlineMap.toSingleValueMap();
        String sign = SignUtil.createMD5Sign(signMap, appSecret);
        couponOnlineMap.add(Finals.SIGN, sign);

//        CouponCreateResponseVo code = fmCouponService.createCode(couponOnlineMap);
//        logger.info(JSONObject.toJSONString(code));
    }

    @Test
    public void promotionSaveUserCoupon() {
        String partnerId = "1864";
        String mobile = "15651101234";
        String activityCode = "MEHG2018121719200242839";
        String code = "88600017957001943687";
        PromotionUserCouponReqVo promotionUserCouponReqVo = new PromotionUserCouponReqVo();
        promotionUserCouponReqVo.setVer(1);
        promotionUserCouponReqVo.setPartnerCode(partnerId);
        promotionUserCouponReqVo.setUserId("115393308065249235");
        promotionUserCouponReqVo.setMobile(mobile);
        List<CouponVo> coupons = new ArrayList<>();
        CouponVo couponVo = new CouponVo();
        couponVo.setCouponCode(code);
        couponVo.setActivityCode(activityCode);
        String startDate = "2018-12-01 00:00:00";
        String endDate = "2019-12-01 00:00:00";
        couponVo.setValidityPeriodStart(DateUtil.convert2Date(startDate, DateUtil.FORMAT_YYYY_MM_DD_HHMMSS));
        couponVo.setValidityPeriodEnd(DateUtil.convert2Date(endDate, DateUtil.FORMAT_YYYY_MM_DD_HHMMSS));
        coupons.add(couponVo);
        promotionUserCouponReqVo.setCoupons(coupons);

        PromotionBaseRespVo promotionBaseRespVo = promotionService.saveUserCoupon(promotionUserCouponReqVo);
        logger.info(JSONObject.toJSONString(promotionBaseRespVo));
    }

    @Test
    public void getmembercoupon() {
        //1617,1617，88600017957134272219
        String partnerId = "1617";
        String memberId = "1617";
        String code = "88600017957134272219";
        MemberCardVo memberCardVo = new MemberCardVo();
        memberCardVo.setPartnerId(partnerId);
        memberCardVo.setMemberId(memberId);
        memberCardVo.setCouponCode(code);
        MemberCouponRespVo<MemberCouponVo> memberCoupon = memberProductService.getMemberCoupon(memberCardVo);
        logger.info(JSONObject.toJSONString(memberCoupon));
    }

    @Test
    public void getMemberCoupon() {
        //1617,1617，88600017957134272219
        String partnerId = "1864";
        String memberId = "1864";
        String code = "88600369801000970417";
        GetMemberCouponRequestVo requestVo=new GetMemberCouponRequestVo();
        requestVo.setCouponCode(code);
        requestVo.setPartnerId(partnerId);
        requestVo.setSessionId("8ecf77ce6af7d266fbbfc990b6e0918a1127e34a");
        GetCouponDetailResponseDto memberCoupon = couponService.getMemberCoupon(requestVo);
        logger.info(JSONObject.toJSONString(memberCoupon));
    }
    @Test
    public void checkSpqInfo() {
        //1617,1617，88600017957134272219
        String partnerId = "1864";
        String memberId = "1617";
        String code = "88600039947518452055";
        CheckSpqInfoRequestDto requestDto=new CheckSpqInfoRequestDto();
        requestDto.setCouponCode(code);
        requestDto.setPartnerId(partnerId);
        requestDto.setStoreId("111");
        CheckSpqInfoResponseDto memberCoupon = couponService.checkSpqInfo(requestDto);
        logger.info(JSONObject.toJSONString(memberCoupon));
    }

    @Test
    public void addCouponActive() {
        String req="{\n" +
                "    \"Active\": {\n" +
                "        \"EBCode\": \"0000000517\",\n" +
                "        \"Type\": 1,\n" +
                "        \"PartnerID\": 1864,\n" +
                "        \"PlatformItemId\": \"\",\n" +
                "        \"State\": 1,\n" +
                "        \"ActiveCode\": \"TS201812181845001\",\n" +
                "        \"ActiveName\": \"SDK代金券测试\",\n" +
                "        \"ActiveDesc\": \"SDK代金券测试\",\n" +
                "        \"CreateUser\": \"SDKadmin\",\n" +
                "        \"CreateDate\": \"2018-12-18T19:05:23\",\n" +
                "        \"LastEditUser\": \"SDKadmin\",\n" +
                "        \"LastEditDate\": \"2018-12-18T19:05:23\",\n" +
                "        \"StartDate\": \"2018-12-18T00:00:00\",\n" +
                "        \"EndDate\": \"2019-12-18T00:00:00\",\n" +
                "        \"ShouldRedeemAll\": 0,\n" +
                "        \"PromotionType\": \"AAA\",\n" +
                "        \"Exclusive\": null,\n" +
                "        \"MinAmount\": 1000,\n" +
                "        \"MaxRedeemTimes\": 1000,\n" +
                "        \"MaxSendOut\": 100,\n" +
                "        \"Cost\": 3.0,\n" +
                "        \"BusinessID\": 1\n" +
                "    },\n" +
                "    \"ActiveProduct\": [\n" +
                "        {\n" +
                "            \"ProductID_Partner\": \"1234567\",\n" +
                "            \"Product\": \"SDK3元代金券\",\n" +
                "            \"Price_Original\": 3,\n" +
                "            \"Price_Discount\": 3,\n" +
                "            \"Amount\": 1,\n" +
                "            \"Paid\": 3,\n" +
                "            \"Remain\": 0\n" +
                "        }\n" +
                "    ],\n" +
                "    \"ActiveRestrict\": [\n" +
                "        {\n" +
                "            \"City\": \"\",\n" +
                "            \"StoreIDPartner\": \"10086\"\n" +
                "        }\n" +
                "    ],\n" +
                "    \"ActiveProductSetting\": [\n" +
                "        {\n" +
                "            \"ProductCode\": \"01000009\",\n" +
                "            \"CategoryCode\": \"\",\n" +
                "            \"Type\": 0\n" +
                "        }\n" +
                "    ]\n" +
                "}";
        String appSecret = "C0CB6FCDE7C745F4AEE81A152F77B728";
        ActiveInsertRequest activeInsertRequest = JSONObject.parseObject(req, ActiveInsertRequest.class);
        activeInsertRequest.setAppSecret(appSecret);
        ActiveInsertRespVo activeInsertRespVo = fmActiveService.insertActive(activeInsertRequest);
        logger.info(JSONObject.toJSONString(activeInsertRespVo));
    }

    @Test
    public void cartTest() {
        ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo = new ShoppingCartGoodsResponseVo();
        /**
         * json string
         */
        String cartGoodsListStr = "[{\"spuName\":\"咖喱鸡套餐\",\"originalPrice\":4300,\"goodsId\":\"186791599886416647\",\"productMaterialList\":[],\"customerCode\":\"20200924001\",\"finalPrice\":200,\"createTimeMili\":1602252322191,\"pic\":\"https://picture.sandload.cn/1600916765127.png\",\"productComboList\":[{\"spuName\":\"桔子单品08\",\"originalPrice\":900,\"goodsId\":\"186550397524170796\",\"customerCode\":\"20200921008\",\"finalPrice\":900,\"pic\":\"https://picture.sandload.cn/1600683267756.png\",\"extra\":[],\"skuId\":\"186550397524170796\",\"amount\":900,\"weight\":0.0,\"tax\":0.01,\"weightType\":false,\"unit\":\"斤\",\"originalAmount\":900,\"taxId\":\"\",\"qty\":1,\"name\":\"桔子单品08\"},{\"spuName\":\"桔子单品09\",\"originalPrice\":1000,\"goodsId\":\"186550397560870958\",\"customerCode\":\"20200921009\",\"finalPrice\":1000,\"pic\":\"https://picture.sandload.cn/1600683289350.png\",\"extra\":[],\"skuId\":\"186550397560870958\",\"amount\":1000,\"weight\":0.0,\"tax\":0.01,\"weightType\":false,\"unit\":\"斤\",\"originalAmount\":1000,\"taxId\":\"\",\"qty\":1,\"name\":\"桔子单品09\"}],\"categoryName\":\"套餐\",\"originalMaterialAmount\":0,\"packPrice\":0,\"skuName\":\"咖喱鸡套餐\",\"riseSell\":1,\"classificationName\":\"肉\",\"productGroupList\":[{\"spuName\":\"桔子单品05\",\"originalPrice\":600,\"goodsId\":\"186550397401487398\",\"productGroupId\":186791000549735219,\"customerCode\":\"20200921005\",\"finalPrice\":100,\"pic\":\"https://picture.sandload.cn/1600682885597.png\",\"extra\":[],\"skuId\":\"186550397401487398\",\"amount\":400,\"weight\":0.0,\"tax\":0.01,\"weightType\":false,\"unit\":\"斤\",\"originalAmount\":2400,\"taxId\":\"\",\"qty\":4,\"name\":\"桔子单品05\"}],\"memberDiscount\":100,\"skuId\":\"186791599886416647\",\"amount\":17200,\"cartGoodsUid\":\"8022f126-bd17-4afc-ab76-52bf28ac8208\",\"stockLimit\":false,\"weight\":0.0,\"tax\":1.01,\"classificationId\":\"meat\",\"goodsType\":3,\"weightType\":false,\"unit\":\"\",\"originalAmount\":17200,\"subName\":\"\",\"taxId\":\"11111\",\"qty\":4,\"name\":\"咖喱鸡套餐\",\"materialAmount\":0,\"spuId\":\"186791599886416647\"}]";
        List<CartGoods> cartGoodsList = JSONObject.parseObject(cartGoodsListStr, new TypeReference<List<CartGoods>>() {
        });

        String discountResultStr = "{\"couponDiscounts\":[],\"originalTotalAmount\":9200,\"totalDiscountAmount\":7998,\"deliveryAmount\":0,\"distributionFee\":0,\"goods\":[{\"gift\":false,\"smallMaterial\":[{\"realAmount\":870,\"discounts\":[{\"activityCode\":\"JTMJ2020092514310052470\",\"goodsId\":\"186550397401487398\",\"activityName\":\"丹妮满减\",\"actualGoodsNumber\":0,\"discount\":584,\"type\":12,\"activityDesc\":\"description\"},{\"activityCode\":\"88607397645364556809\",\"goodsId\":\"186550397401487398\",\"activityName\":\"test0917\",\"actualGoodsNumber\":0,\"discount\":146,\"type\":3,\"activityDesc\":\"test0917\"}],\"originalPrice\":100,\"goodsId\":\"186550397401487398\",\"discountAmount\":730,\"goodsQuantity\":4,\"type\":2}],\"groupCombox\":[{\"discounts\":[{\"activityCode\":\"TCYH0000000001\",\"goodsId\":\"186550397524170796\",\"activityName\":\"套餐活动优惠\",\"actualGoodsNumber\":0,\"discount\":816,\"type\":310,\"activityDesc\":\"套餐活动优惠\"},{\"goodsId\":\"186550397524170796\",\"activityName\":\"danny现时折扣924002\",\"actualGoodsNumber\":0,\"discount\":23,\"type\":21},{\"goodsId\":\"186550397524170796\",\"activityName\":\"丹妮满减\",\"actualGoodsNumber\":0,\"discount\":25,\"type\":12},{\"goodsId\":\"186550397524170796\",\"activityName\":\"test0917\",\"actualGoodsNumber\":0,\"discount\":6,\"type\":3}],\"originalPrice\":900,\"goodsId\":\"186550397524170796\",\"discountAmount\":870,\"goodsQuantity\":1},{\"discounts\":[{\"activityCode\":\"TCYH0000000001\",\"goodsId\":\"186550397560870958\",\"activityName\":\"套餐活动优惠\",\"actualGoodsNumber\":0,\"discount\":884,\"type\":310,\"activityDesc\":\"套餐活动优惠\"},{\"goodsId\":\"186550397560870958\",\"activityName\":\"danny现时折扣924002\",\"actualGoodsNumber\":0,\"discount\":25,\"type\":21},{\"goodsId\":\"186550397560870958\",\"activityName\":\"丹妮满减\",\"actualGoodsNumber\":0,\"discount\":28,\"type\":12},{\"goodsId\":\"186550397560870958\",\"activityName\":\"test0917\",\"actualGoodsNumber\":0,\"discount\":7,\"type\":3}],\"originalPrice\":1000,\"goodsId\":\"186550397560870958\",\"discountAmount\":944,\"goodsQuantity\":1}],\"cartGoodsUid\":\"8022f126-bd17-4afc-ab76-52bf28ac8208\",\"originalPrice\":7000,\"goodsId\":\"186791599886416647\",\"actualGoodsNumber\":4,\"discountAmount\":7268,\"meal\":true,\"realAmount\":332,\"nowPrice\":2,\"discounts\":[{\"activityCode\":\"DPZK2020092416390298325\",\"goodsId\":\"186791599886416647\",\"activityName\":\"danny现时折扣924002\",\"actualGoodsNumber\":1,\"discount\":198,\"type\":21},{\"activityCode\":\"JTMJ2020092514310052470\",\"goodsId\":\"186791599886416647\",\"activityName\":\"丹妮满减\",\"actualGoodsNumber\":4,\"discount\":216,\"type\":12},{\"activityCode\":\"88607397645364556809\",\"goodsId\":\"186791599886416647\",\"activityName\":\"test0917\",\"actualGoodsNumber\":4,\"discount\":54,\"type\":3},{\"activityCode\":\"TCYH0000000001\",\"goodsId\":\"186791599886416647\",\"activityName\":\"套餐活动优惠\",\"actualGoodsNumber\":0,\"discount\":6800,\"type\":310,\"activityDesc\":\"套餐活动优惠\"}],\"goodsQuantity\":4,\"cartGoodType\":0}],\"apportionGoods\":[],\"stocks\":[{\"activityCode\":\"DPZK2020092416390298325\",\"activityType\":21,\"goodsStock\":[{\"goodsId\":\"186791599886416647\",\"stock\":1}]},{\"activityCode\":\"JTMJ2020092514310052470\",\"activityStock\":1,\"activityType\":12,\"goodsStock\":[]}],\"totalAmount\":1202,\"discounts\":[{\"activityCode\":\"DPZK2020092416390298325\",\"activityName\":\"danny现时折扣924002\",\"discount\":198,\"type\":21,\"activityDesc\":\"\"},{\"activityCode\":\"JTMJ2020092514310052470\",\"thresholdAmount\":1000,\"activityName\":\"丹妮满减\",\"discount\":800,\"type\":12,\"activityDesc\":\"description\"},{\"activityCode\":\"88607397645364556809\",\"activityName\":\"test0917\",\"discount\":200,\"type\":3},{\"activityCode\":\"TCYH0000000001\",\"activityName\":\"套餐活动优惠\",\"discount\":6800,\"type\":310,\"activityDesc\":\"套餐活动优惠\"}],\"validCouponMap\":{}}";
        CalculationSharingDiscountResponseDto.CalculationDiscountResult discountResult = JSONObject.parseObject(discountResultStr, new TypeReference<CalculationSharingDiscountResponseDto.CalculationDiscountResult>() {
        });
        /**
         * 用促销价格初始化购物车行记录成交价
         */
        calculationCommonService.initShoppingCart(discountResult, cartGoodsList, shoppingCartGoodsResponseVo);
        /**
         * 满减处理
         */
        fullSharingService.fullResponse(discountResult, cartGoodsList, shoppingCartGoodsResponseVo, null);

    }

}
