package cn.freemud.entities.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import java.util.ArrayList;
import java.util.List;

@Data
public class BenefitBeanDto implements Comparable<BenefitBeanDto>{
    /**
     * 优惠券名称
     */
    private String benefitName;
    /**
     * 优惠门槛（分）
     */
    private Integer thresholdAmount;

    private Integer benefitNumber;
    /**
     * 优惠金额（分）
     */
    private Integer discountAmount;
    /**
     * 优惠等级（用于阶梯满减）
     */
    private Integer benefitSeq;

    private Integer benefitType;
    private List<ActivitySendGoodsVO> sendGoodsList;

    @Override
    public int compareTo(BenefitBeanDto o) {
        return  this.thresholdAmount.compareTo(o.getThresholdAmount());
    }

    @Data
    public static class ActivitySendGoodsVO {
        /**
         * 活动号
         */
        private String activityCode;

        /**
         * 商品id
         */
        private String goodsId;

        /**
         * 商品CODE
         */
        private String goodsCode;

        /**
         * 商品名
         */
        private String goodsName;

        /**
         * 原价
         */
        private Integer originalPrice;

        /**
         * 现价
         */
        private Integer nowPrice;

        /**
         * 限制数量
         */
        private Integer quantityLimit;

        /**
         * 赠送数量
         */
        private Integer sendNumber;

        /**
         * 赠品类型 0或null为计件赠品  1为称重赠品
         */
        private Integer sendGoodsType;

        /**
         * 赠品重量 g为单位
         */
        private Integer sendGoodsWeight;

        /**
         * 排序
         */
        private Integer serialNumber;

        /**
         * 商品类型：2、是加料商品，9、是虚拟商品，7、是套餐商品，1、是单品
         */
        private Integer productType;
        /**
         * 商品可兑换的券号
         */
        private String sendCouponCode;

        /**
         * 商品可兑换的券名称
         */
        private String sendCouponName;

        /**
         * 是否兑换券
         */
        private boolean sendCoupon=false;
    }
}