package cn.freemud.demo.adapter.service;

import cn.freemud.demo.entities.bo.CheckAdapterBO;
import cn.freemud.demo.entities.bo.goods.AddGoodsToShoppingCartBO;
import cn.freemud.demo.entities.bo.goods.CheckBussinessRulesBO;
import cn.freemud.demo.utils.CommonUtils;
import cn.freemud.entities.dto.CheckSpqInfoRequestDto;
import cn.freemud.entities.dto.CheckSpqInfoResponseDto;
import cn.freemud.entities.dto.GetMemberCouponListRequestDto;
import cn.freemud.entities.dto.GetMemberCouponListResponseDto;
import cn.freemud.entities.vo.CartGoods;
import cn.freemud.enums.CouponStatus;
import cn.freemud.enums.GoodsTypeEnum;
import cn.freemud.enums.ResponseResult;
import cn.freemud.interceptor.ServiceException;
import cn.freemud.service.CouponService;
import com.freemud.sdk.api.assortment.shoppingcart.constant.CommonsConstant;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

@Component
public class CheckAdapter {


    @Autowired
    private CouponService couponService;

    public void adapter(CheckBussinessRulesBO checkBussinessRulesBO, AddGoodsToShoppingCartBO addGoodsToShoppingCartBO, CheckAdapterBO bo) {
        // 校验后有效的商品券map
        List<CartGoods> cartGoodsList = addGoodsToShoppingCartBO.getCartGoods();
        HashMap<String, CheckSpqInfoResponseDto> validCouponMap = new HashMap<>(16);
        HashMap<String, List<String>> spqIdToCartUuid = new HashMap<>(16);

        // 校验后有效的商品券map
        GetMemberCouponListRequestDto getMemberCouponListRequestDto = new GetMemberCouponListRequestDto(bo.getPartnerId(), bo.getUserId());
        getMemberCouponListRequestDto.setStatusFlags(Arrays.asList(CouponStatus.STATUS_0.getCode(), CouponStatus.STATUS_2.getCode()));
        getMemberCouponListRequestDto.setPageNum(1);
        getMemberCouponListRequestDto.setPageSize(Integer.MAX_VALUE);
        List<GetMemberCouponListResponseDto.Result.MemberCoupon> validMemberCouponList = couponService.getValidMemberCouponList(getMemberCouponListRequestDto, bo.getOrderType());

        for (int i = 0; i < cartGoodsList.size(); i++) {
            CartGoods cartGoods = cartGoodsList.get(i);
            if (!CommonUtils.isProductCoupon(cartGoods.getCouponCode(), cartGoods.getCartGoodsUid())) {
                continue;
            }
            if (CollectionUtils.isEmpty(validMemberCouponList)) {
                throw new ServiceException(ResponseResult.SHOPPING_CART_USER_HAVE_NO_COUPON, ResponseResult.SHOPPING_CART_USER_HAVE_NO_COUPON.getMessage());
            }
            String couponCode = CommonUtils.getCouponCode(cartGoods.getCouponCode(), cartGoods.getCartGoodsUid());
            GetMemberCouponListResponseDto.Result.MemberCoupon memberCoupon = validMemberCouponList.stream().filter(p -> couponCode.equals(p.getCouponCode())).findFirst().orElse(null);
            if (memberCoupon == null) {
                throw new ServiceException(ResponseResult.SHOPPING_CART_USER_HAVE_NO_COUPON, ResponseResult.SHOPPING_CART_USER_HAVE_NO_COUPON.getMessage());
            }
            // 优惠券放在coupon字段而不是uuid中
            boolean useCoupon = true;
            if (cartGoods.getCartGoodsUid().startsWith(CommonsConstant.COUPON_PREFIX)) {
                useCoupon = false;
            }
            CheckSpqInfoRequestDto checkSpqInfoRequestDto = new CheckSpqInfoRequestDto(bo.getPartnerId(), bo.getShopId(), couponCode, bo.getMenuType(),null);
            CheckSpqInfoResponseDto checkSpqInfo;
            if (GoodsTypeEnum.HG_COUPON_GOODS.getGoodsType().equals(cartGoods.getGoodsType())) {
                checkSpqInfo = couponService.checkSpqInfo(checkSpqInfoRequestDto, cartGoods.getSkuId());
            } else {
                checkSpqInfo = couponService.checkSpqInfo(checkSpqInfoRequestDto,null);
            }
            if (null == checkSpqInfo) {
                cartGoodsList.remove(i--);
            } else {
                cartGoods.setActivityCode(checkSpqInfo.getActiveCode());
                cartGoods.setCouponProductPrice(checkSpqInfo.getPrice());
                validCouponMap.put(couponCode, checkSpqInfo);
                if (useCoupon) {
                    validCouponMap.put(couponCode + checkSpqInfo.getSkuId(), checkSpqInfo);
                }
                List<String> uuidList = spqIdToCartUuid.computeIfAbsent(couponCode,k->new ArrayList<>());
                uuidList.add(cartGoods.getCartGoodsUid());
            }
        }

        addGoodsToShoppingCartBO.setSpqIdToCartUuidMap(spqIdToCartUuid);
        addGoodsToShoppingCartBO.setValidCouponMap(validCouponMap);

    }

}
