/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderInfoReqs
 * @Package com.freemud.application.sdk.api.ordercenter.response.orderInfo
 * @Description:
 * @author: ping.wu
 * @date: 2019/4/2 17:21
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.application.sdk.api.ordercenter.response.orderInfo;

import com.freemud.application.sdk.api.ordercenter.request.OrderExtendedReq;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;
// fisherman
@Data
public class OrderInfoReqs {

    /**
     * 订单异常具体描述
     */
    private String abnormalDesc;
    /**
     * 订单异常状态 0:正常（无异常）1:异常
     */
    private Integer abnormalState;

    /**
     * 父订单编号
     */
    private String parentCode;

    private Boolean isParent;

    /**
     * 售后单状态 1:待处理 2:退货中 3:拒绝退款 4:已退货 5:完成 6:取消
     */
    private Integer afterSalesState;

    /**
     * 是否需要开发票
     */
    private Boolean isNeedInvoice;

    /**
     * 是否立即送达
     */
    private Boolean isImmediately;

    /**
     * 取消原因
     */
    private String cancelReason;

    /**
     * 打印时间
     */
    private String printTime;

    /**
     * 接单时间
     */
    private String acceptTime;

    /**
     * 实际到达时间
     */
    private String actualArrivalTime;

    /**
     * 捡货时间（制作完成发货的时间）
     */
    private String pickUpTime;

    /**
     * 创建时间
     */
    private String createTime;

    /**
     * 更新时间
     */
    private String updateTime;

    /**
     * POS专用更新时间戳
     */
    private Long updateTimestamp;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 商户号
     */
    private String partnerId;

    /**
     * 商户名
     */
    private String partnerName;

    /**
     * 门店编号
     */
    private String storeId;

    /**
     * 第三方门店编号
     */
    private String thirdStoreId;

    /**
     * 门店名
     */
    private String storeName;

    /**
     * 门店英文名
     */
    private String storeNameEn;

    /**
     * 门店全局唯一编号
     */
    private String storeUnifyId;

    /**
     * 目的门店
     */
    private String toStoreId;

    /**
     * 用户ID
     */
    private String userId;

    /**
     * 用户姓名
     */
    private String userName;

    /**
     * 默认为待支付状态，如需要则设置对应的值
     */
    private Integer orderState;

    /**
     * 正常情况下不要设置值，此字段仅在做订单同步时使用 订单子状态
     */
    private Integer orderSubState;

    /**
     * 订单类型
     */
    private Integer orderType;

    /**
     * 正常情况下不要设置值，此字段仅在做订单同步时使用 1:未支付 2:已支付 3:已退款 4:部分退款
     */
    private Integer payState;

    private Integer payType;

    /**
     * 当前支付请求号
     */
    private String payRequestNo;

    /**
     * 支付渠道
     */
    private String payChannel;

    /**
     * 支付渠道名称
     */
    private String payChannelName;

    /**
     * 配送状态
     */
    private Integer deliveryState;

    /**
     * 订单原始金额，单位分
     */
    private BigDecimal originalAmount;

    /**
     * 用户在界面上看到的支付金额
     */
    private BigDecimal settlementAmount;

    /**
     * 实际支付现金金额，扣除支付自生优惠，单位分
     */
    private BigDecimal actualPayAmount;

    /**
     * 是否已开票，true已开票，默认false未开票
     */
    private Boolean needInvoice;

    /**
     * 下单渠道必填，根据此字段的值判断是自营或第三方，来走不同的状态机 详细见 orderClientType枚举
     */
    private Integer orderClient;

    /**
     * 商户自己生成的订单号
     */
    private String companySelfCode;

    /**
     * 第三方订单号/客户展示订单编号
     */
    private String thirdOrderCode;

    /**
     * 订单备注
     */
    private String note;

    /**
     * 扩展字段
     */
    private String extInfo;

    /**
     * 取货号 取餐号
     */
    private String pickUpGoodsNo;

    /**
     * 门店订单序号
     */
    private Integer daySeq;

    /**
     * 订单特殊类型 1:普通订单 2:拼团订单 3:秒杀订单 4:拼单订单
     */
    private Integer marketingType;

    /**
     * 销售类型对应的场景值
     */
    private String marketingCode;

    /**
     * 配送类型 1自配送(三方渠道配送、商家店员配送) 2平台配送")
     */
    private Integer expressType;

    /**
     * 配送渠道名称
     */
    private String expressChannelName;

    /**
     * 配送渠道编号
     */
    private String expressChannelCode;

    /**
     * 快递单号
     */
    private String expressNo;

    /**
     * 重量
     */
    private BigDecimal weight;

    /**
     * 是否能退货 是否有退货商品
     */
    private Boolean canRefund;

    /**
     * 支付时间
     */
    private String payTime;

    /**
     * 发货时间
     */
    private String deliveryTime;

    /**
     * 签收时间 送达时间 收货时间
     */
    private String receiveTime;

    /**
     * 桌台号
     */
    private String barCounter;

    /**
     * pos编号
     */
    private String posCode;

    /**
     * 就餐人数
     */
    private Integer dinersNumber;

    /**
     * 小程序本地tableKey
     */
    private String localTableKey;

    /**
     * pos table key
     */
    private String posTableKey;

    /**
     * 用户预约时间，仅为预约单时存放
     */
    private String expectTime;

    /**
     * 打印次数
     */
    private Integer printNum;

    /**
     * 订单业务类型 1:普通订单 2:虚拟订单
     */
    private Integer bizType;

    /**
     * 挂起状态 0 正常 1 未成团挂起 2 风控挂起 3 售中取消挂起
     */
    private Integer suspendState;

    /**
     * 挂起状态描述
     */
    private String suspendDesc;

    /**
     * 承诺送达标识  0-无承诺 60-1小时达 120-2小时达 180-3小时达 1440-隔日达
     */
    private Short deliveryPromise;

    /**
     * 预计送达时间
     */
    private String estimateDeliveryCompleteTime;
    /**
     * 下单区域
     */
    private String orderArea;

    private Integer dispenseStatus;

    /**
     * 是否立即送达
     */
    private Boolean immediately;

    /**
     * 下游POS商编号
     */
    private String downstreamPosCode;

    /**
     * 下游订单号
     */
    private String downstreamThirdOrderCode;

    /**
     * 支付渠道类型
     */
    private String payChannelType;

    private String appId;

    /*** 区分订单来源 0:KA 1:开个店 2019-07-29　基础服务新增字段　***/
    private Byte sourceType;

    /**
     * 操作人
     */
    private String operator;

    /**
     * 下单用户手机号
     */
    private String userMobile;

    /**
     * 订单扩展信息 （门店渠道信息）
     */
    private OrderExtendedReq orderExtended;

    /**
     * 发票明细
     */
    private OrderInvoice orderInvoice;

    /**
     * 订单商品信息
     */
    private List<OrderItemResp> orderItemList;

    /**
     * 配送联系信息
     */
    private List<DeliveryContactInfoResp> deliveryContactInfoList;

    /**
     * 订单费用信息
     */
    private List<OrderCostResp> orderCostDetailList;

    /**
     * 订单结算信息
     */
    private List<OrderSettlementResp> orderSettlementDetailList;
    /**
     * 售后单信息
     */
    private List<AfterSalesOrderResp> afterSalesOrderList;

    /**
     * 订单操作历史
     */
    private List<OrderOperationHistoryResp> orderOperationHistoryList;

    /**
     * 支付信息
     */
    private List<OrderPayItemResp> orderPayItemCreateReqList;

    private List<OrderSendCouponResp> orderSendCouponRespList;

}
