package cn.freemud.enums;

public enum CostTypeEnum {

    PACK_AMOUNT(1, "包装费"),
    DELIVERY_AMOUNT(2, "运费"),
    CARD_ORIGINAL_AMOUNT(5, "会员卡费用"),
    MCCAFE_MONTH_CARD(10, "麦咖啡月卡"),
    ;

    private Integer code;
    private String desc;

    CostTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CostTypeEnum getByCode(Integer code) {
        for (CostTypeEnum costType : values()) {
            if (costType.getCode().equals(code)) {
                return costType;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
