package cn.freemud.config;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: ${FILE_NAME}
 * @Package com.freemud.mail.core
 * @Description: ${TODO}(用一句话描述该文件做什么)
 * @author: aiqi.gong
 * @date: 2019/3/18 18:07
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

import ch.qos.logback.classic.Level;
import com.alibaba.fastjson.JSONObject;
import com.freemud.application.sdk.api.base.SDKCommonBaseContextWare;
import com.freemud.application.sdk.api.log.ErrorLog;
import com.freemud.application.sdk.api.log.LogThreadLocal;
import com.freemud.application.sdk.api.log.ThirdPartyLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.*;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class OpenStoreCloudService {
    @Autowired
    @Qualifier("openStoreRestTemplate")
    private RestTemplate openStoreRestTemplate;

    @Autowired
    @Qualifier("configRestTemplate")
    private RestTemplate configRestTemplate;

    public <T, R> R doSend(String trackingNo, String url, T requestBody, Class<R> response) {
        return send(openStoreRestTemplate, trackingNo, url, requestBody, response);
    }

    public <T, R> R getConfig(String trackingNo, String url, T requestBody, Class<R> response) {
        return send(configRestTemplate, trackingNo, url, requestBody, response);
    }


    private <T, R> R send(RestTemplate restTemplate, String trackingNo, String url, T requestBody, Class<R> response) {
        long startTime = System.currentTimeMillis();
        ResponseEntity<String> entity = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity<T> httpReq = new HttpEntity<>(requestBody, headers);
        try {
            entity = restTemplate.exchange(url, HttpMethod.POST, httpReq, String.class);
            ThirdPartyLog.infoConvertJson(LogThreadLocal.getTrackingNo(), SDKCommonBaseContextWare.getAppName(), startTime, System.currentTimeMillis(), url, requestBody, entity);
        } catch (Exception e) {
           // ErrorLog.errorConvertJson("openStoreCloudService send", "调用接口异常", startTime, System.currentTimeMillis(), url, httpReq, e);
            //String appName, String methodName, String message, HttpServletRequest request, long startTime, long endTime, Object requestData, Exception ex
            ErrorLog.printErrorLog(SDKCommonBaseContextWare.getAppName(), LogThreadLocal.getTrackingNo(), e.getMessage(), url, requestBody, e, Level.ERROR);

        }
        try {
            return entity != null ? JSONObject.parseObject(entity.getBody(), response) : response.newInstance();
        } catch (Exception e) {
            ErrorLog.infoConvertJson(SDKCommonBaseContextWare.getAppName(), LogThreadLocal.getTrackingNo(), getClass(), "OpenStoreCloudService类型转换异常", e);
        }
        return null;
    }


}

