package cn.freemud.adapter;/**
 * @author wangxinqi1
 * @Date 2019/2/22 10:28
 */

import cn.freemud.base.util.DateUtil;
import cn.freemud.constant.UserInfoKeyConstant;
import cn.freemud.entities.dto.BuryingPointBigDto;
import cn.freemud.entities.dto.GetWxappUserInfoDto;
import cn.freemud.entities.dto.GetWxappUserInfoResponseDto;
import cn.freemud.entities.dto.PointRegisterDto;
import cn.freemud.entities.vo.GetUserLoginSessionIdVo;
import cn.freemud.entities.vo.RegisterByUnionIdRequestVo;
import cn.freemud.entities.vo.UserLoginVo;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.Map;

/**
 * @program: micro_progeram_service
 * @description: 大数据同步
 * @author: xinqi.wang
 * @create: 2019-02-22 10:28
 **/
@Component
public class BigDataAdapter {


    public BuryingPointBigDto convert2BuryingPoint(String appid, String partnerId, GetUserLoginSessionIdVo requestUserLoginVo, GetWxappUserInfoDto getWxappUserInfoDto, GetWxappUserInfoResponseDto.ResultBean resultBean, UserLoginVo userLoginVo) {
        //大数据埋点
        BuryingPointBigDto buryingPointBigDto = new BuryingPointBigDto();
        buryingPointBigDto.setUnifyId(partnerId);
        buryingPointBigDto.setStoreId("");
        buryingPointBigDto.setAppType("iorder");
        buryingPointBigDto.setAppId(appid);
        buryingPointBigDto.setPrePage("");
        buryingPointBigDto.setPrePageCN("");
        buryingPointBigDto.setCurPage("storeListShop");
        buryingPointBigDto.setCurPageCN("登录主页");
        buryingPointBigDto.setAction("view");

        buryingPointBigDto.setModule("");
        buryingPointBigDto.setModuleCN("");
        buryingPointBigDto.setObject("");
        buryingPointBigDto.setObjectCN("");
        buryingPointBigDto.setObjectDetail("");
        buryingPointBigDto.setObjectDetailCN("");
        buryingPointBigDto.setChannel(requestUserLoginVo.getChannel());
        buryingPointBigDto.setPmtChan("");
        buryingPointBigDto.setPmtChanDetail("");
        buryingPointBigDto.setUnionId(userLoginVo.getUnionId());
        buryingPointBigDto.setSessionId(userLoginVo.getSessionId());
        buryingPointBigDto.setUid(userLoginVo.getMemberId() + "");
        buryingPointBigDto.setOpenId(userLoginVo.getOpenId());
        buryingPointBigDto.setIsNew((userLoginVo.getRegistered() ^ 1) + "");
        buryingPointBigDto.setIsLogin("1");
        buryingPointBigDto.setDevBrand(requestUserLoginVo.getDevBrand());
        buryingPointBigDto.setDevModel(requestUserLoginVo.getDevModel());
        buryingPointBigDto.setIp("");
        buryingPointBigDto.setCtime(DateUtil.convert2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
        buryingPointBigDto.setTs(System.currentTimeMillis());
        buryingPointBigDto.setCts(Long.parseLong(requestUserLoginVo.getCts()));
        buryingPointBigDto.setLatitude("");
        buryingPointBigDto.setLongitude("");
        buryingPointBigDto.setOpt1("");
        buryingPointBigDto.setOpt2("");
        return buryingPointBigDto;
    }

    public BuryingPointBigDto convert2PointRegister(RegisterByUnionIdRequestVo registerByUnionIdRequestVo, String partnerId, String sessionId, Map<String, Object> userInfoMap) {
        //大数据埋点
        BuryingPointBigDto buryingPointBigDto = new BuryingPointBigDto();
        buryingPointBigDto.setUnifyId(partnerId);
        buryingPointBigDto.setStoreId("");
        buryingPointBigDto.setAppType("iorder");
        buryingPointBigDto.setAppId(registerByUnionIdRequestVo.getAppId());
        buryingPointBigDto.setPrePage("");
        buryingPointBigDto.setPrePageCN("");
        buryingPointBigDto.setCurPage("memberRegisterPage");
        buryingPointBigDto.setCurPageCN("会员注册主页");
        buryingPointBigDto.setAction("view");

        buryingPointBigDto.setModule("");
        buryingPointBigDto.setModuleCN("");
        buryingPointBigDto.setObject("");
        buryingPointBigDto.setObjectCN("");
        buryingPointBigDto.setObjectDetail("");
        buryingPointBigDto.setObjectDetailCN("");
        buryingPointBigDto.setChannel(registerByUnionIdRequestVo.getChannel());
        buryingPointBigDto.setPmtChan("");
        buryingPointBigDto.setPmtChanDetail("");
        buryingPointBigDto.setUnionId(userInfoMap.get(UserInfoKeyConstant.UNION_ID) + "");
        buryingPointBigDto.setSessionId(sessionId);
        buryingPointBigDto.setUid(userInfoMap.get(UserInfoKeyConstant.MEMBER_ID) + "");
        buryingPointBigDto.setOpenId(userInfoMap.get(UserInfoKeyConstant.OPEN_ID) + "");
        Boolean newMember = false;
        if (userInfoMap.get(UserInfoKeyConstant.NEW_MEMBER) != null) {
            newMember = Boolean.valueOf(userInfoMap.get(UserInfoKeyConstant.NEW_MEMBER).toString());
        }
        buryingPointBigDto.setIsNew(newMember ? "1" : "0");
        buryingPointBigDto.setIsLogin("1");
        buryingPointBigDto.setDevBrand(registerByUnionIdRequestVo.getDevBrand());
        buryingPointBigDto.setDevModel(registerByUnionIdRequestVo.getDevModel());
        buryingPointBigDto.setIp("");
        buryingPointBigDto.setCtime(DateUtil.convert2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
        buryingPointBigDto.setTs(System.currentTimeMillis());
        buryingPointBigDto.setCts(System.currentTimeMillis());
        buryingPointBigDto.setLatitude("");
        buryingPointBigDto.setLongitude("");
        buryingPointBigDto.setOpt1("");
        buryingPointBigDto.setOpt2("");
        return buryingPointBigDto;
    }

    public BuryingPointBigDto convert2PointRegister(PointRegisterDto pointRegisterDto) {
        Map<String, Object> userInfoMap = pointRegisterDto.getUserInfoMap();
        //大数据埋点
        BuryingPointBigDto buryingPointBigDto = new BuryingPointBigDto();
        buryingPointBigDto.setUnifyId(pointRegisterDto.getPartnerId());
        buryingPointBigDto.setStoreId(pointRegisterDto.getStoreId());
        buryingPointBigDto.setAppType("iorder");
        buryingPointBigDto.setAppId(pointRegisterDto.getAppId());
        buryingPointBigDto.setPrePage("");
        buryingPointBigDto.setPrePageCN("");
        buryingPointBigDto.setCurPage(pointRegisterDto.getCurPage());
        buryingPointBigDto.setCurPageCN(pointRegisterDto.getCurPageCN());
        buryingPointBigDto.setAction("view");

        buryingPointBigDto.setModule("");
        buryingPointBigDto.setModuleCN("");
        buryingPointBigDto.setObject("");
        buryingPointBigDto.setObjectCN("");
        buryingPointBigDto.setObjectDetail("");
        buryingPointBigDto.setObjectDetailCN("");
        buryingPointBigDto.setChannel(pointRegisterDto.getChannel());
        buryingPointBigDto.setPmtChan("");
        buryingPointBigDto.setPmtChanDetail("");
        buryingPointBigDto.setUnionId(userInfoMap.get(UserInfoKeyConstant.UNION_ID) + "");
        buryingPointBigDto.setSessionId(pointRegisterDto.getSessionId());
        buryingPointBigDto.setUid(userInfoMap.get(UserInfoKeyConstant.MEMBER_ID) + "");
        buryingPointBigDto.setOpenId(userInfoMap.get(UserInfoKeyConstant.OPEN_ID) + "");
        Boolean newMember = false;
        if (userInfoMap.get(UserInfoKeyConstant.NEW_MEMBER) != null) {
            newMember = Boolean.valueOf(userInfoMap.get(UserInfoKeyConstant.NEW_MEMBER).toString());
        }
        buryingPointBigDto.setIsNew(newMember ? "1" : "0");
        buryingPointBigDto.setIsLogin("1");
        buryingPointBigDto.setDevBrand(pointRegisterDto.getDevBrand());
        buryingPointBigDto.setDevModel(pointRegisterDto.getDevModel());
        buryingPointBigDto.setIp("");
        buryingPointBigDto.setCtime(DateUtil.convert2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
        buryingPointBigDto.setTs(System.currentTimeMillis());
        buryingPointBigDto.setCts(System.currentTimeMillis());
        buryingPointBigDto.setLatitude("");
        buryingPointBigDto.setLongitude("");
        buryingPointBigDto.setOpt1("");
        buryingPointBigDto.setOpt2("");
        return buryingPointBigDto;
    }

}
