package cn.freemud.enums;

public enum  CouponActiveStateEnum {

    /**
     * 只有1和2能发，一般没有2
     */
    STATE_0(0, "未启用"),
    STATE_1(1, "启用"),
    STATE_2(2, "开始"),
    STATE_3(3, "结束"),
    STATE_4(4, "暂停"),
    STATE_5(5, "作废"),
    STATE_6(6, "禁用")
    ;

    private Integer code;
    private String desc;

    CouponActiveStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CouponActiveStateEnum getByCode(Integer code) {
        for (CouponActiveStateEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

}
