package cn.freemud.service.thirdparty;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.vo.AddUserOrderEvaluationNewRequestVo;
import cn.freemud.entities.vo.AddUserOrderEvaluationRequestVo;
import cn.freemud.entities.vo.GetEvaluationDetailByOrderIdRequestVo;
import cn.freemud.entities.vo.GetEvaluationStatusNewRequestVo;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(name = "MICRO-SUPPORT-SERVICE",url = "${saas.microsupportclient.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface MicroSupportClient {

    @PostMapping("/evaluation/addEvaluationDetail")
    BaseResponse addEvaluationDetail(@RequestBody AddUserOrderEvaluationRequestVo request);

    @PostMapping("/evaluation/addEvaluationDetailNew")
    BaseResponse addEvaluationDetailNew(@RequestBody AddUserOrderEvaluationNewRequestVo request);

    @PostMapping("/evaluation/getEvaluteDetailByOrderId")
    BaseResponse getEvaluteDetailByOrderId(@RequestBody GetEvaluationDetailByOrderIdRequestVo request);

    @PostMapping("/evaluation/getEvaluationStatus")
    BaseResponse getEvaluationStatus(@RequestBody GetEvaluationDetailByOrderIdRequestVo request);

    @PostMapping("/evaluation/getEvaluationStatusNew")
    BaseResponse getEvaluationStatusNew(@RequestBody GetEvaluationStatusNewRequestVo request);

}
