/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ActivityRecordRequest
 * @Package cn.freemud.entities.request
 * @Description:
 * @author: xudong.cai
 * @date: 2018/8/1 21:32
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.dto;

import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.validation.annotation.Validated;

import java.util.List;

@Validated
@Data
public class EntershopRecordDto {

    /**
     * 活动ID
     */
    @NotBlank(message = "activityId不允许为空 ")
    private String activityId;

    /**
     * 用户ID
     */
    @NotBlank(message = "userId不能为空")
    private String userId;

    /**
     * 订单ID
     */
    private String orderId;

    /**
     * 奖品类型
     */
    private String prizeType;

    /**
     * 商户ID
     */
    @NotBlank(message = "partnerId不能为空")
    private String partnerId;

    /**
     * 门店ID
     */
    @NotBlank(message = "storeId不能为空")
    private String storeId;

    /**
     * 门店名称
     */
    @NotBlank(message = "storeName不能为空")
    private String storeName;

    /**
     * 数量，外部传入，可以为空
     */
    private Integer num;

    /**
     * 订单金额，以分为单位，可以为空
     */
    private Integer orderPrice;

    /**
     * 其他存储信息，可以额外存储JSON等信息（如商品信息等）
     */
    private String recordInfo;

    private List<CouponInfo> coupons;

    @Data
    public static class CouponInfo {
        /**
         * 券id，可以为空
         */
        private String couponId;
        /**
         * 奖品ID，可以为空，可以是外部传入
         */
        private String prizeId;
        /**
         * 奖品名，外部传入，可以为空
         */
        private String prizeProductName;
        /**
         * 扣减金额，以分为单位，可以为空
         */
        private Integer price;
    }
}
