package cn.freemud.entities.dto.promotion;

import io.swagger.annotations.ApiModelProperty;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import java.util.List;

public class ActivityStockVO {
    @ApiModelProperty(value="活动库存", name="activityStock", example="100")
    @Min(1)
    private Integer activityStock;

    @ApiModelProperty(value="商品库存列表", name="goodsStock")
    @Valid
    private List<ActivityGoodsStockVO> goodsStock;

    public Integer getActivityStock() {
        return activityStock;
    }

    public void setActivityStock(Integer activityStock) {
        this.activityStock = activityStock;
    }

    public List<ActivityGoodsStockVO> getGoodsStock() {
        return goodsStock;
    }

    public void setGoodsStock(List<ActivityGoodsStockVO> goodsStock) {
        this.goodsStock = goodsStock;
    }
}