package cn.freemud.entities.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * @author Clover.z
 * @Date 2021/11/1
 * @Desc
 */
@Data
public class UpdateGiftAttrRequestVo {

    /**
     * 商户Id
     */
    @ApiModelProperty("商户Id")
    @NotBlank(message = "partnerId不能为空")
    private String partnerId;
    /**
     * 门店号
     */
    @ApiModelProperty("门店号")
    @NotBlank(message = "shopId不能为空")
    private String shopId;

    /**
     * 用户登陆session
     */
    @ApiModelProperty("用户登陆session")
    @NotBlank(message = "请先登陆")
    private String sessionId;

    /**
     * 要更新的购物车赠品行id
     */
    @ApiModelProperty("要更新的购物车赠品行id")
    @NotBlank(message = "购物车行id不能为空")
    private String uid;

    /**
     * 赠品选择的属性信息
     */
    @ApiModelProperty("赠品选择的属性信息")
    @NotEmpty(message = "请选择属性")
    @Valid
    private List<ExtraAttr> extra;

    @Data
    public static class ExtraAttr {
        @ApiModelProperty("属性id")
        @NotBlank
        private String attributeId;
        @ApiModelProperty("属性名称")
        @NotBlank
        private String attributeName;
    }
}
