/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderItemResp
 * @Package com.freemud.application.sdk.api.ordercenter.response.orderInfo
 * @Description:
 * @author: ping.wu
 * @date: 2019/4/2 17:29
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.application.sdk.api.ordercenter.response.orderInfo;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class OrderItemResp {

    //商户号
    private String partnerId;

    //商品编号，商品服务唯一标识，SKU
    private String productId;

    //默认false，ignoreInOrderClose=false表示这个明细退完才能关单;ignoreInOrderClose=true表示这个明细没有退，但是该订单其他明细退完了就关单了
    private Boolean ignoreInOrderClose = false;

    //三方商品ID、SKU 商品服务唯一
    private String thirdProductId;

    //商品货号，商品服务可重复
    private String productCode;

    //订单商品明细ID
    private Long id;

    //父商品编号，主要用户组合商品
    private String parentProductId;

    //订单编号
    private String orderCode;

    //商品名称
    private String productName;

    //商品英文名称
    private String productForeignName;

    //商品序号
    private Integer productSeq;

    //商品规格编号
    private String productSpec;

    //商品规格名称
    private String productSpecName;
    //商品规格英文名称
    private String productForeignSpecName;


    //商品UPC码
    private String productUpc;

    //购买数量
    private Integer productQuantity;

    //产品单位如份、杯
    private String productUnit;

    //商品单价
    private BigDecimal productPrice;

    //用户在界面上看到的支付金额，单位分
    private BigDecimal settlementPrice;

    //销售价格
    private BigDecimal salePrice;

    //优惠分摊金额
    private BigDecimal productSharePrice;

    //产品图片URL
    private String productPicUrl;

    //商品属性
    private String productProperty;

    //商品属性
    private String productForeignProperty;

    //重量
    private BigDecimal weight;

    //重量单位
    private Byte productWeightUnit;

    // @ApiModelProperty(value = CanRefundType.API_DESC)
    private Boolean canRefund = true;

    //销售类型或营销活动类型 1普通订单 2秒杀订单 3推广活动 4拼单订单
    private Byte marketingType;

    //活动ID
    private String marketingCode;

    //备注
    private String note;

    //商品类型 --6
    private Integer productType;

    //商品明细扩展对象
    private String extInfo;

    //加购人ID
    private String userId;

    //加购人openId
    private String openId;

    //加购人昵称
    private String nickName;

    //加购人头像
    private String photoUrl;

    //加购人包装费
    private Long packPrice;

    /**
     * 订单新增商品SPU数量字段  https://cf.freemudvip.com/pages/viewpage.action?pageId=209356052
     */
    private Integer productSpuQuantity;


    @Data
    public static class ExtInfo {
        /**
         * 是否是赠品
         */
        private Boolean isSendGoods;
        /**
         * 购物车行id
         */
        private String cartGoodsUid;
        /**
         * 积分商品活动使用总积分
         */
        private Long score;
        /**
         * 是否是固定搭配
         */
        private Boolean isFixedProduct;
        /**
         * spu商品货号
         */
        private String spuProductCode;
        /**
         * 属性三方id， 多个用,拼接（推送pos需要）
         */
        private String thirdProductPropertyId;
        /**
         * 三方规格值id， 多个用,拼接（推送pos需要）
         */
        private String thirdProductSpecId;
        /**
         * 凌顶pos 商品编码id
         */
        private String linkedId;
        /**
         * 买一赠一时， 赠品商品的该属性表示原商品购物车id
         * 其他赠送活动， 这里设置为活动号
         */
        private String originalId;
        /**
         * 商品组信息
         */
        private List<ExtGroup> productGroupList;
        /**
         * 商品属性信息
         */
        private List<ExtAttr> specialAttrs;
        /**
         * 虚拟商品绑定的券信息
         */
        private List<CouponInfo> productBindingCoupons;

        /**
         * 参与会员价活动时，用户所生效的会员卡或者会员等级名称
         */
        private String currentMembershipLevel;

        /**
         * 是否限制库存
         * 用于创建订单时，是否扣减库存
         */
        private boolean stockLimit;
        /**
         * 套餐库存模式
         */
        private Integer stockMode;

    }

    @Data
    public static class ExtAttr {
        /**
         * 属性id
         */
        private String extraId;
        /**
         * 属性名称
         */
        private String extraName;
    }

    @Data
    public static class ExtGroup {
        /**
         * 商品组id
         */
        private String groupId;
        /**
         * 商品组名称
         */
        private String groupName;
        /**
         * 第三方商品组编码
         */
        private String thirdGroupId;
    }

    @Data
    public static class CouponInfo {
        /**
         * 券模板(券活动号)
         */
        private String activityCode;
        /**
         * 券模板名称(活动名称)
         */
        private String activityName;
        /**
         * 券商品数量
         */
        private Integer num;
    }
}
