/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ItemServiceImpl
 * @Package cn.freemud.service.impl
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/15 19:24
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.service.impl;

import cn.freemud.adapter.StoreItemAdapter;
import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.entities.dto.*;
import cn.freemud.entities.dto.product.*;
import cn.freemud.entities.vo.GetProductsVo;
import cn.freemud.enums.ProductInfoType;
import cn.freemud.service.ItemService;
import cn.freemud.service.thirdparty.StoreItemClient;
import cn.freemud.utils.AppLogUtil;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

@Service
public class OrderItemServiceImpl implements ItemService{

    private static Gson gson = new Gson();

    @Autowired
    private StoreItemClient storeItemClient;
    @Autowired
    private StoreItemAdapter storeItemAdapter;

    /**
     * 传spuid集合查询所有里面所有sku商品信息
     * 包括商品的套餐子商品
     * 返回商品的第三方编号（唯一）、第三方货号、第三方规格id，第三方属性id
     */
    public Map<String, GetProductsVo> getSpuProducts(List<String> spuIds, String partnerId, String storeId,String menuType) {
        Map<String, GetProductsVo> resultMap = new HashMap<>();
        if (CollectionUtils.isEmpty(spuIds)) {
            return resultMap;
        }
        //去重
        List<String> result = spuIds.stream().distinct().collect(Collectors.toList());
        //查询商品详情
        GetProductInfoDto getProductInfoDto = storeItemAdapter.convert2ProductInfoDto(partnerId, storeId, ProductInfoType.ALL.getCode(), result,menuType);
        ProductInfosDto productInfosDto = storeItemClient.listProductInfos(getProductInfoDto);
        if (ResponseCodeConstant.RESPONSE_SUCCESS.equals(productInfosDto.getErrcode()) && productInfosDto.getData() != null
                && CollectionUtils.isNotEmpty(productInfosDto.getData().getProducts())) {
            //1传货号给当三方商品编号给pos
            boolean toPosCustomerCode = productInfosDto.getData().getToPosProductIdType() != null && productInfosDto.getData().getToPosProductIdType() == 1;
            productInfosDto.getData().getProducts().forEach(productBean -> {
                GetProductsVo spuProductsVo = new GetProductsVo();

                spuProductsVo.setSpuProductCode(productBean.getProductCode());
                //保存货号到三方商品编号字段
                if(toPosCustomerCode){
                    spuProductsVo.setCustomerCode(productBean.getProductCode());
                    spuProductsVo.setProductCode(productBean.getCustomerCode());
                }else {
                    spuProductsVo.setCustomerCode(productBean.getCustomerCode());
                    spuProductsVo.setProductCode(productBean.getProductCode());
                }
                List<AttributeValue> attributeValues  = new ArrayList<>();
                //第三方商品属性信息
                if (CollectionUtils.isNotEmpty(productBean.getProductAttributeGroupList())) {
                    for (ProductAttributeGroup attributeGroupListBean : productBean.getProductAttributeGroupList()) {
                        if (CollectionUtils.isEmpty(attributeGroupListBean.getAttributeValues())) {
                            continue;
                        }
                        attributeValues.addAll(attributeGroupListBean.getAttributeValues());
                    }
                }
                spuProductsVo.setProductAttributeGroupList(productBean.getProductAttributeGroupList());

                // todo 商品组信息
                if(CollectionUtils.isNotEmpty(productBean.getProductGroupList())){
                    spuProductsVo.setProductGroupList(productBean.getProductGroupList());
                }

                resultMap.put(productBean.getPid(), spuProductsVo);

                //多规格商品
                saveSkuProductsThirdInfo(productBean,productBean.getProductAttributeGroupList(),resultMap,toPosCustomerCode);
                //套餐商品内子商品
                saveComboProductsThirdInfo(productBean,resultMap,toPosCustomerCode);
            });
        }
        return resultMap;
    }


    /**
     * 多规格商品保存第三方信息
     */
    private void saveSkuProductsThirdInfo(ProductInfo productBean,List<ProductAttributeGroup> productAttributeGroupList,
                                          Map<String, GetProductsVo> resultMap, boolean toPosCustomerCode){
        if (CollectionUtils.isNotEmpty(productBean.getSkuList())) {
            for (SkuProduct skuProductBean : productBean.getSkuList()) {
                GetProductsVo skuProductsVo = new GetProductsVo();

                skuProductsVo.setSpuProductCode(productBean.getProductCode());
                //保存货号到三方商品编号字段
                if(toPosCustomerCode){
                    skuProductsVo.setCustomerCode(skuProductBean.getProductCode());
                    skuProductsVo.setProductCode(skuProductBean.getCustomerCode());
                }else {
                    skuProductsVo.setCustomerCode(skuProductBean.getCustomerCode());
                    skuProductsVo.setProductCode(skuProductBean.getProductCode());
                }
                //第三方商品规格值id
                if (CollectionUtils.isNotEmpty(skuProductBean.getSkuSpecValues())) {
                    List<String> list = new ArrayList<>();
                    for (SkuSpecValue skuSpecValue : skuProductBean.getSkuSpecValues()) {
                        if (StringUtils.isBlank(skuSpecValue.getSpecValueCustomerCode())) {
                            continue;
                        }
                        list.add(skuSpecValue.getSpecValueCustomerCode());
                    }
                    if (CollectionUtils.isNotEmpty(list)) {
                        String specCustomerCodes = StringUtils.join(list, ",");
                        skuProductsVo.setThirdProductSpecId(specCustomerCodes);
                    }
                }
                skuProductsVo.setProductAttributeGroupList(productAttributeGroupList);
                resultMap.put(skuProductBean.getSkuId(), skuProductsVo);
            }
        }
    }

    /**
     * 套餐商品保存第三方信息
     */
    private void saveComboProductsThirdInfo(ProductInfo productBean,Map<String, GetProductsVo> resultMap,boolean toPosCustomerCode){
        GetProductsVo spuProductsVo = resultMap.get(productBean.getPid());
        List<Integer> stapleFood = Arrays.asList(0,1);
        //套餐固定商品
        if (CollectionUtils.isNotEmpty(productBean.getProductComboList())) {
            for (ProductComboListDto productComboListDto : productBean.getProductComboList()) {
                GetProductsVo comboProductsVo = new GetProductsVo();

                comboProductsVo.setSpuProductCode(productComboListDto.getProductCode());
                //保存货号到三方商品编号字段
                if(toPosCustomerCode){
                    comboProductsVo.setCustomerCode(productComboListDto.getProductCode());
                    comboProductsVo.setProductCode(productComboListDto.getCustomerCode());
                }else {
                    comboProductsVo.setCustomerCode(productComboListDto.getCustomerCode());
                    comboProductsVo.setProductCode(productComboListDto.getProductCode());
                }
                if (productComboListDto.getIsStaple()!=null && stapleFood.contains(productComboListDto.getIsStaple())) {
                    comboProductsVo.setStapleFood(productComboListDto.getIsStaple());
                } else {
                    comboProductsVo.setStapleFood(0);
                }
                //第三方商品属性信息
                comboProductsVo.setProductAttributeGroupList(productComboListDto.getProductAttributeGroupList());
                if(CollectionUtils.isNotEmpty(spuProductsVo.getProductGroupList())){
                    /** 商品组 */
                    for(ProductGroup group : spuProductsVo.getProductGroupList()){
                        if(CollectionUtils.isNotEmpty(group.getGroupDetail())){
                            for(GroupDetail detail : group.getGroupDetail()){
                                if(detail.getProductId().equals(productComboListDto.getProductId())){
                                    ProductGroup targetGroup = new ProductGroup();
                                    targetGroup.setGroupCode(group.getGroupCode());
                                    targetGroup.setName(group.getName());
                                    targetGroup.setGroupDetail(Lists.newArrayList(detail));
                                    List<ProductGroup> productGroupList = Lists.newArrayList(targetGroup);
                                    comboProductsVo.setProductGroupList(productGroupList);
                                    break;
                                }
                            }
                        }
                    }
                }

                resultMap.put(productComboListDto.getProductId(), comboProductsVo);
            }
        }

        //套餐商品内可选商品
        if (CollectionUtils.isNotEmpty(productBean.getProductGroupList()) && CollectionUtils.isNotEmpty(productBean.getProductGroupList().get(0).getGroupDetail())) {
            //套餐商品可选商品集合
            for(ProductGroup group : productBean.getProductGroupList()){
                for(GroupDetail groupDetailBean : group.getGroupDetail()){
                    //多规格获取sku信息
                    GetProductsVo groupProductsVo = new GetProductsVo();

                    groupProductsVo.setSpuProductCode(groupDetailBean.getProductCode());
                    //保存货号到三方商品编号字段
                    if(toPosCustomerCode){
                        groupProductsVo.setCustomerCode(groupDetailBean.getProductCode());
                        groupProductsVo.setProductCode(groupDetailBean.getCustomerCode());
                    }else {
                        groupProductsVo.setCustomerCode(groupDetailBean.getCustomerCode());
                        groupProductsVo.setProductCode(groupDetailBean.getProductCode());
                    }
                    //第三方商品属性信息
                    groupProductsVo.setProductAttributeGroupList(groupDetailBean.getProductAttributeGroupList());

                    ProductGroup targetGroup = new ProductGroup();
                    targetGroup.setGroupCode(group.getGroupCode());
                    targetGroup.setName(group.getName());
                    targetGroup.setGroupDetail(Lists.newArrayList(groupDetailBean));
                    List<ProductGroup> productGroupList = Lists.newArrayList(targetGroup);
                    groupProductsVo.setProductGroupList(productGroupList);

                    resultMap.put(groupDetailBean.getProductId(), groupProductsVo);
                }
            }
        }
    }

}
