package cn.freemud.entities.dto.pay;

import cn.freemud.enums.InvoiceTypeCodeEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import java.util.List;

@Data
public class InvoiceCreateRequest {
    @ApiModelProperty(value = "商户编号")
    private String partnerId;

    @ApiModelProperty(value = "开票终端代码，1纸票，2电票")
    private String invoiceTerminalCode;

    @ApiModelProperty(value = "机构代码,如果为空则上传至税号对应的机构下，如果维护了机构则按照机构归属待开信息")
    private String orgCode;

    @ApiModelProperty(value = "推送渠道标识，0为微信扫码url，默认为null")
    private Integer pushChannelType;

    /**
     * @see InvoiceTypeCodeEnum
     */
    @ApiModelProperty(value = "发票类型,1：增值税专用发票；2：增值税普通发票；3：增值税电子发票；4：增值税卷式发票；5:增值税专用电子发票")
    @NotEmpty(message = "发票类型不能为空")
    private String invoiceTypeCode;

    @ApiModelProperty(value = "开票流水号")
    @NotEmpty(message = "开票流水号不能为空")
    private String invoiceNo;

    @ApiModelProperty(value = "开票人")
    @NotEmpty(message = "开票人不能为空")
    private String drawer;

    @ApiModelProperty(value = "含税标志,默认不含税 {0-不含税，1-含税}")
    private String priceTaxMark = "0";

    @ApiModelProperty(value = "发票明细")
    private List<InvoiceProductDetailRequest> productDetailList;

    @ApiModelProperty("appKey")
    private String appKey;

    @ApiModelProperty("appSercret")
    private String appSercret;

    @ApiModelProperty("clientCode")
    private String clientCode;


    @ApiModelProperty("盐值，加密盐")
    private String salt;

    @ApiModelProperty("税号")
    private String taxNo;

    @ApiModelProperty("userName")
    private String userName;

    @ApiModelProperty("password")
    private String password;
}
