package cn.freemud.management.entities.dto.response.coupon;

import lombok.Data;

/**
 * 麦当劳.net商品信息响应对象
 * <p>
 * 此对象和.net接口保持一致
 *
 * @author Tony
 */
@Data
public class McdNetCouponProductRespDto {

    /**
     * 商户商品编号（或键位编号）
     */
    private String pid;

    /**
     * 商品自增id
     */
    private String mcd_productCode;

    /**
     * 商品名称
     */
    private String name;

    /**
     * 商品数量
     */
    private Integer amount;

    /**
     * 可用商品个数
     */
    private Integer number;

    /**
     * 商品折扣价，以分为单位
     */
    private Integer price_act;

    /**
     * 商品原价
     */
    private Integer price_original;

    /**
     * 支付信息
     */
    private McdNetCouponPaymentRespDto payment;

}
