package cn.freemud.service;

import cn.freemud.entities.vo.CartGoods;
import cn.freemud.enums.GoodsTypeEnum;
import cn.freemud.service.impl.AssortmentSdkService;
import com.freemud.sdk.api.assortment.shoppingcart.service.impl.ShoppingCartBaseServiceImpl;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.List;
import java.util.Objects;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title:
 * @Package: cn.freemud.service.thirdpart
 * @Description:
 * @author: biao.zhang
 * @date: 2018/12/17 16:34
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
public class ShoppingCartNewBaseServiceTest {
    @Autowired
    private ShoppingCartNewBaseService shoppingCartNewBaseService;

    @Autowired
    private AssortmentSdkService assortmentSdkService;
    @Autowired
    private ShoppingCartBaseServiceImpl shoppingCartBaseService;


    @Test
    public void getCartGoodsList() {
//        List<CartGoods> list = shoppingCartNewBaseService.getCartGoodsList("1864", "1011", "123");
//        assertTrue(CollectionUtils.isNotEmpty(list));
    }

    @Test
    public void setCartGoodsList() {
        List<CartGoods> cartGoodsList = Lists.newArrayList();
        CartGoods cartsGoods = new CartGoods();
        cartsGoods.setGoodsId("1");
        cartsGoods.setSpuId("2");
        cartsGoods.setSkuId("3");
        cartsGoods.setQty(1);
        cartsGoods.setGoodsType(GoodsTypeEnum.COMMON_GOODS.getGoodsType());
        List<CartGoods.CartGoodsExtra> extras = Lists.newArrayList();
        CartGoods.CartGoodsExtra cartGood = new CartGoods.CartGoodsExtra();
        cartGood.setAttributeId("1");
        cartGood.setAttributeName("属性名称");
        extras.add(cartGood);
        cartsGoods.setExtra(extras);
        cartGoodsList.add(cartsGoods);
//        List<CartGoods> list = shoppingCartNewBaseService.setCartGoodsList("1864", "1011", "123", cartGoodsList);
//        assertTrue(CollectionUtils.isNotEmpty(list));
    }

    @Test
    public void updateGoodsQty() {
        List<CartGoods> list = assortmentSdkService.updateGoodsQtyBySdk("1864", "1011", "123", "4srwtergew", 1, "", this.shoppingCartBaseService,null);
        assertTrue(CollectionUtils.isNotEmpty(list));
    }

    @Test
    public void getCartGoods() {
        CartGoods cartGoods = assortmentSdkService.getCartGoodsBySdk("1864", "1011", "123", "142sfdrasr", "", this.shoppingCartBaseService,null);
        assertFalse(Objects.equals(cartGoods, null));
    }

    @Test
    public void clearTest() {
        shoppingCartNewBaseService.clear("1864", "1011", "123",null);
    }

}
