package cn.freemud.service.thirdparty;

import cn.freemud.annotations.LogIgnoreFeign;
import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.pay.svc.BatchSvcInfoRequest;
import cn.freemud.entities.dto.pay.svc.CardApplyRes;
import cn.freemud.entities.dto.pay.svc.SVCCardAmountRequestDto;
import cn.freemud.entities.dto.pay.svc.SVCCardAmountResponseDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

@FeignClient(name = "fm-svc-app", url = "${saas.svc.app.feign.url:}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface SvcAppClient {

    //批量查询卡余额
    @PostMapping(value = "/svc/card/batch-query-card-amount")
    @LogIgnoreFeign(logMessage = "batchQueryCardAmount")
    BaseResponse<SVCCardAmountResponseDto> batchQueryCardAmount(SVCCardAmountRequestDto svcComPayRequestDto);


    //批量查询卡配置规则
    @PostMapping(value = "/svc/cardapply/multi-info")
    @LogIgnoreFeign(logMessage = "/svc/cardapply/multi-info")
    BaseResponse<List<CardApplyRes>> multiInfo(@RequestBody List<BatchSvcInfoRequest> requestList);

}
