/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ShoppingCartClient
 * @Package cn.freemud.service.thirdparty
 * @Description:
 * @author: ping.wu
 * @date: 2018/5/18 18:09
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.service.thirdparty;

import cn.freemud.annotations.LogIgnoreFeign;
import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.*;
import cn.freemud.entities.dto.shoppingCart.GetShoppingCartGoodsApportionDto;
import cn.freemud.entities.dto.shoppingCart.NewShoppingCartClearDto;
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.dto.shoppingCart.CollageOrderDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(name = "SHOPPING-CART-APPLICATION-SERVICE",url = "${saas.newshoppingcartclient.feign.url}")
@RequestMapping(value = "/shoppingCart",produces = {"application/json;charset=UTF-8"})
public interface ShoppingCartClient {

    /**
     * 购物车添加商品
     * @param request
     * @return
     */
    @LogIgnoreFeign(logMessage="addShoppingCart")
    @PostMapping(value = "/add?lang=zh_CN")
    ShoppingCartInfoDto addShoppingCart(@RequestBody AddShoppingCartRequestDto request);

    /**
     * 修改购物车商品数量
     * @param request
     * @return
     */
    @LogIgnoreFeign(logMessage="updateShoppingCart")
    @PostMapping(value = "/updateCartInfo?lang=zh_CN")
    ShoppingCartBaseResponse updateShoppingCart(@RequestBody UpdateShoppingCartRequestDto request);

    /**
     * 查询购物商品
     * @param request
     * @return
     */
    @LogIgnoreFeign(logMessage="getShoppingCart")
    @PostMapping(value = "/detail?lang=zh_CN")
    ShoppingCartInfoDto getShoppingCart(@RequestBody GetShoppingCartDto request);


    /**
     * 清空购物车
     * @param request
     * @return
     */
    @LogIgnoreFeign(logMessage="clearShoppingCart")
    @PostMapping(value = "/clearCartGoods?lang=zh_CN")
    ShoppingCartBaseResponse clearShoppingCart(@RequestBody NewShoppingCartClearDto request);


    /**
     * 麦咖啡清空购物车
     * @param request
     * @return
     */
    @LogIgnoreFeign(logMessage="clearMCCafeShoppingCart")
    @PostMapping(value = "/MCoffee/clearCartGoods?lang=zh_CN")
    ShoppingCartBaseResponse clearMCCafeShoppingCart(@RequestBody NewShoppingCartClearDto request);


    /**
     * 获取购物车详情，包含均摊信息
     */
    @LogIgnoreFeign(logMessage="getShoppingCartGoodsApportionNew")
    @PostMapping(value = "/getShoppingCartGoodsApportion?lang=zh_CN")
    BaseResponse<ShoppingCartGoodsDto> getShoppingCartGoodsApportionNew(@RequestBody GetShoppingCartGoodsApportionDto getShoppingCartGoodsApportionDto);

    /**
     * 麦咖啡获取购物车详情，包含均摊信息
     */
    @LogIgnoreFeign(logMessage="getMCCafeShoppingCartGoodsApportionNew")
    @PostMapping(value = "/MCoffee/getShoppingCartGoodsApportion?lang=zh_CN")
    BaseResponse<ShoppingCartGoodsDto> getMCCafeShoppingCartGoodsApportionNew(@RequestBody GetShoppingCartGoodsApportionDto getShoppingCartGoodsApportionDto);

    /**
     * 获取拼单订单购物车详情，包含均摊信息
     */
    @LogIgnoreFeign(logMessage="getCollageShoppingCartGoodsApportion")
    @PostMapping(value = "/collage/getShoppingCartGoodsApportion?lang=zh_CN")
    BaseResponse<ShoppingCartGoodsDto> getCollageShoppingCartGoodsApportion(@RequestBody GetShoppingCartGoodsApportionDto getShoppingCartGoodsApportionDto);

    /**
     * 清空拼单购物车
     */
    @LogIgnoreFeign(logMessage="clearCollageOrder")
    @PostMapping(value = "/collage/clearOrder?lang=zh_CN")
    BaseResponse clearCollageOrder(@RequestBody NewShoppingCartClearDto newShoppingCartClearDto);

    /**
     * 更新拼单信息
     */
    @LogIgnoreFeign(logMessage="updateCollageOrder")
    @PostMapping(value = "/collage/updateOrder?lang=zh_CN")
    BaseResponse updateCollageOrder(@RequestBody CollageOrderDto collageOrderDto);

    /**
     * 获取拼单状态信息
     */
    @LogIgnoreFeign(logMessage="getCollageOrderStatus")
    @PostMapping(value = "/collage/getOrderStatus?lang=zh_CN")
    BaseResponse<Integer> getCollageOrderStatus(@RequestBody CollageOrderDto collageOrderDto);

}
