/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: TimeoutOrderRequestVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: ping.wu
 * @date: 2019/4/15 18:56
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.application.sdk.api.ordercenter.entities.vo;

import lombok.Data;

@Data
public class OrderCallBackRequestVo {

    /**
     * 订单号
     */
    private String orderCode;
    // 售后单编号（operateType=2返回）
    private String afterSalesCode;
    /**
     * 延迟通知类型
     * 2 未支付超时关单
     */
    private Integer delayMsgEventType;
    //操作类型 0= 其他信息修改，1=订单正向操作，2=订单逆向操作,3=通知消息
    private Integer operateType;
    //渠道编号
    private Integer orderClient;

    /**
     * 商户号
     */
    private String partnerId;

    /**
     * 门店号
     */
    private String storeId;

    /**
     * 消息类型
     1.	1订单所有状态正常变化通知
     2.	2超时订单
     3.	3通知
     */
    private String msgType;

    /**
     * 订单orderResp json对象
     */
    private String content;

    /**
     * 请求ID
     */
    private String requestId;

    /**
     * 默认为待支付状态，如需要则设置对应的值
     */
    private Integer orderState;
}
