package cn.freemud.management.thirdparty;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.management.annotations.LogIgnoreFeign;
import cn.freemud.management.constant.ResponseCodeConstant;
import cn.freemud.management.constant.ResponseCodeKeyConstant;
import cn.freemud.management.thirdparty.request.OrderSellCouponRefundRequest;
import com.freemud.application.sdk.api.deliverycenter.response.DeliveryResponseDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(name = "ASSISTANT-SERVICE", url = "${saas.assistantserviceclient.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface FMAssistantApplicationClient {


    /**
     * 、
     * 非码侧拒绝接单|取消订单  抖音核销券业务取消订单操作
     */
    @PostMapping("/assistant/thirdparty/order/refund")
    @LogIgnoreFeign(excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR}, messageFieldName = ResponseCodeKeyConstant.MSG, printLog = true)
    BaseResponse orderRefund(@RequestBody OrderSellCouponRefundRequest request);
}
