package cn.freemud.utils;

import cn.freemud.enums.ActivityChannelEnum;
import cn.freemud.enums.CreateOrderType;
import com.freemud.application.sdk.api.ordercenter.enums.orderv1.OrderTypeV1;

import java.util.Objects;

public class PropertyConvertUtil {

    public static ActivityChannelEnum orderTypeConvert2ActivityChannel(Integer orderType) {
        if (Objects.equals(CreateOrderType.TAKE_OUT.getCode(), orderType)) {
            return ActivityChannelEnum.delivery;
        } else if (Objects.equals(CreateOrderType.COLLECT_GOODS.getCode(), orderType)) {
            return ActivityChannelEnum.pickup;
        }else if (Objects.equals(CreateOrderType.SAASMALL.getCode(), orderType)) {
            return ActivityChannelEnum.saasmall;
        }else {
            return ActivityChannelEnum.pickup;
        }
    }

    public static ActivityChannelEnum orderTypeEnumConvert2ActivityChannel(Integer orderType) {
        if (Objects.equals(OrderTypeV1.TAKE_OUT.getCode(), orderType)) {
            return ActivityChannelEnum.delivery;
        } else if (Objects.equals(OrderTypeV1.COLLECT_GOODS.getCode(), orderType) || Objects.equals(OrderTypeV1.EAT_IN.getCode(), orderType)) {
            return ActivityChannelEnum.pickup;
        }else {
            return ActivityChannelEnum.pickup;
        }
    }
}
