/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: GetActivitiesDto
 * @Package cn.freemud.entities.dto
 * @Description:
 * @author: liming.guo
 * @date: 2018/8/6 12:04
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.dto;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@NoArgsConstructor
public class  CreateActivityRecordDto {

    /**
     * 活动ID
     */
    private String activityId;
    /**
     * 商户ID
     */
    private String partnerId;
    /**
     * 门店ID
     */
    private String storeId;
    /**
     * 门店名称
     */
    private String storeName;

    /**
     * 用户ID
     */
    private String userId;
    /**
     * 订单ID
     */
    private String orderId;
    /**
     * 奖品类型 否
     */
    private String prizeType;
    /**
     * 奖品ID 否
     */
    private String prizeId;
    /**
     * 奖品名，外部传入 否
     */
    private String prizeProductName;
    /**
     * 数量，外部传入 否
     */
    private Integer num;
    /**
     * 扣减金额，以分为单位，可以为空
     */
    private Long price;
    /**
     * 商品总金额
     */
    private Long orderPrice;
    /**
     * 券id，可以为空
     */
    private String couponId;
    /**
     * 其他存储信息，可以额外存储JSON等信息（如商品信息等） 否
     */
    private String recordInfo;

    /**
     * 创建时间
     */
    private Long createTime;

    private RecordExtInfo recordExtInfo;


    @NoArgsConstructor
    @Data
    public static class RecordExtInfo {

        private List<limitProductDto> limitProductDtoList;

    }

    @NoArgsConstructor
    @Data
    public static class limitProductDto {

        private String skuId;
        private String skuName;
        private Integer number;
        private Long originPrice;
        private Long salePrice;

    }


}
