/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: CreateOrderRequestDto
 * @Package cn.freemud.entities.dto
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/18 14:18
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.dto;

import cn.freemud.entities.dto.order.CreateOrderAccountDto;
import cn.freemud.entities.dto.order.CreateOrderProductDto;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
public class CreateOrderRequestDto {
    /**
     * 商户ID 必填
     */
    private String companyId;
    /**
     * 门店ID
     */
    private String shopId;
    /**
     * 门店名称
     */
    private String shopName;
    /**
     * 用户ID
     */
    private String userId;
    /**
     * 用户名称
     */
    private String userName;
    /**
     * 用户电话
     */
    private String phone;
    /**
     * 收货地址 非必填
     */
    private String address;
    /**
     * 收货地址经度 非必填
     */
    private String longitude;
    /**
     * 收获地址维度  非必填
     */
    private String latitude;
    /**
     * 订单类型  1 外卖 2.预订单 3.商城 4 自提
     */
    private Integer type;
    /**
     * 订单状态
     */
    private Integer status;
    /**
     * 支付类型
     */
    private Integer payType;
    /**
     * 订单来源
     */
    private String source;
    /**
     * 订单来源名称
     */
    private String sourceName;
    /**
     * 期望送达时间
     */
    private Long gmtExpect;

    /**
     * 订单备注
     */
    private String remark;

    /**
     * 实付金额
     */
    private Long amount;

    /**
     * 商品列表
     */
    private List<CreateOrderProductDto> products;
    /**
     * 其他结算列表
     */
    private List<CreateOrderAccountDto> accounts;

    private DeliveryTypeInfo addInfo;

    @Data
    @NoArgsConstructor
    public static class DeliveryTypeInfo {
        /**
         * 订单类型，自配送self，第三方配送third
         */
        private String deliveryType;

        public DeliveryTypeInfo(String deliveryType) {
            this.deliveryType = deliveryType;
        }
    }
}
