package cn.freemud.manager;

import cn.freemud.entities.db.OpenPlatformPartnerMerchant;
import cn.freemud.manager.dao.OpenPlatformPartnerMerchantDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: OpenPlatformPartnerMerchantManager
 * @Package cn.freemud.manager
 * @Description: 简单描述下这个类是做什么用的
 * @author: zhenghuan.yang
 * @date: 2018/7/30 17:34
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Component
public class OpenPlatformPartnerMerchantManager {
    @Autowired
    private OpenPlatformPartnerMerchantDao openPlatformPartnerMerchantDao;

    public OpenPlatformPartnerMerchant selectMerchantDetail(Long id) {
        OpenPlatformPartnerMerchant openPlatformPartnerMerchant = new OpenPlatformPartnerMerchant();
        openPlatformPartnerMerchant.setId(id);
        return openPlatformPartnerMerchantDao.selectByPrimaryKey(openPlatformPartnerMerchant);
    }

    public List<OpenPlatformPartnerMerchant> selectMerchantList(List<String> partnerId) {
        return openPlatformPartnerMerchantDao.selectMerchantList(partnerId);
    }

    public List<OpenPlatformPartnerMerchant> selectMerchantListByPartnerId(String partnerId) {
        OpenPlatformPartnerMerchant pars = new OpenPlatformPartnerMerchant();
        pars.setPartnerId(partnerId);
        return openPlatformPartnerMerchantDao.select(pars);
    }

    public int addMerchant(OpenPlatformPartnerMerchant openPlatformPartnerMerchant) {
        return openPlatformPartnerMerchantDao.insert(openPlatformPartnerMerchant);
    }

    public OpenPlatformPartnerMerchant selectMerchantByMchId(String mchId, String partnerId) {
        OpenPlatformPartnerMerchant openPlatformPartnerMerchant = new OpenPlatformPartnerMerchant();
        openPlatformPartnerMerchant.setMchId(mchId);
        openPlatformPartnerMerchant.setPartnerId(partnerId);
        return openPlatformPartnerMerchantDao.selectOne(openPlatformPartnerMerchant);
    }

    public int updateMerchantById(OpenPlatformPartnerMerchant openPlatformPartnerMerchant) {
        return openPlatformPartnerMerchantDao.updateByPrimaryKeySelective(openPlatformPartnerMerchant);
    }
}
