package cn.freemud.enums;

import com.freemud.application.sdk.api.ordercenter.enums.OrderType;

public enum TakeCodeOrderType {

    TAKE_OUT(1, "外卖"),

    PRE_ORDER(2, "预订单"),

    MALL(3, "商城"),

    COLLECT_GOODS(4, "打包带走"),

    EAT_IN(5, "店内就餐");

    private Integer code;
    private String desc;

    TakeCodeOrderType(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static Integer getTakeCodeOrderType(Integer orderType) {
        if (orderType == null) {
            return null;
        }
        boolean delivery = orderType.equals(OrderType.GENERAL_EXPRESS.getIndex()) || orderType.equals(OrderType.RESERVED_EXPRESS.getIndex());
        if (delivery) {
            return TakeCodeOrderType.TAKE_OUT.getCode();
        }

        boolean pickUp = orderType.equals(OrderType.GENERAL_SELF_PICKUP.getIndex()) || orderType.equals(OrderType.RESERVED_SELF_PICKUP.getIndex());
        if (pickUp) {
            return TakeCodeOrderType.COLLECT_GOODS.getCode();
        }

        boolean eatIn = orderType.equals(OrderType.GENERAL_DINE_IN.getIndex()) || orderType.equals(OrderType.RESERVED_DINE_IN.getIndex());
        if (eatIn) {
            return TakeCodeOrderType.EAT_IN.getCode();
        }
        return null;
    }
}
