/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderAccountType
 * @Package cn.freemud.enums
 * @Description:
 * @author: liming.guo
 * @date: 2018/8/7 17:30
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.enums;

public enum OrderAccountType {

    DELIVERY_AMOUNT(1, "配送费"),
    BUY_DISCOUNT(2, "满减优惠"),
    PACK_AMOUNT(3, "包装费"),
    COUPON(5, "代金券"),
    PRODUCT_COUPON(6, "商品券"),
    DISCOUNT_COUPON(7, "折扣券"),
    DISCOUNT_AMOUNT(21, "限时折扣金额"),
    PREMIUM_EXCHANGE(22, "加价购"),
    SECOND_DISCOUNT(23, "第二件N折"),
    BUYM_SENDN(24, "买M赠N"),
    CUSTOMER_SUB(4, "积分扣减"),
    CARD_ORIGINAL_AMOUNT(25, "会员卡原价"),
    CARD_DISCOUNT_AMOUNT(26, "会员卡优惠金额"),
    COCO_PRODUCT_CASH_COUPON(36, "coco商品代金券"),
    BUYM_SENDN_230(230, "满赠");;
    private Integer code;

    private String desc;

    OrderAccountType(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static OrderAccountType getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (OrderAccountType type : OrderAccountType.values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
